% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safe_shortname.R
\name{safe_shortname}
\alias{safe_shortname}
\title{Rename products using a shorten convention}
\usage{
safe_shortname(
  prod_name,
  prod_type = NULL,
  ext = NULL,
  res = "10m",
  tiles = NULL,
  force_tiles = NULL,
  full.name = TRUE,
  allow_duplicated = FALSE,
  set.seed = NULL,
  multiple_names = NULL,
  abort = FALSE
)
}
\arguments{
\item{prod_name}{Input Sentinel-2 product name (it is not required
that the file exists).}

\item{prod_type}{(optional) Output product (default: \code{TOA} for L1C, \code{BOA}
for L2A); see the details for the list of accepted products.}

\item{ext}{(optional) Extension of the output filename (default: none).}

\item{res}{(optional) Spatial resolution (one between '10m', '20m' or '60m');
default is '10m'. Notice that, choosing '10m' or '20m', bands with lower
resolution will be rescaled to \code{res}. Band 08 is used with \code{res = '10m'},
band 08A with \code{res = '20m'} and \code{res = '60m'}.}

\item{tiles}{Deprecated (no more used).}

\item{force_tiles}{Deprecated (no more used).}

\item{full.name}{Logical value: if TRUE (default), all the input path
is maintained (if existing); if FALSE, only basename is returned.}

\item{allow_duplicated}{Logical value: if TRUE, duplicated values are
maintained; if FALSE (default), in case of duplicated value a suffix is
added to the tile ID (see \code{add_tile_suffix()}).}

\item{set.seed}{Deprecated (no more used).}

\item{multiple_names}{Deprecated (no more used).}

\item{abort}{Logical parameter: if TRUE, the function aborts in case
\code{prod_type} is not recognised; if FALSE (default), a warning is shown.}
}
\value{
Output product name
}
\description{
This function renames a Sentinel-2 product in order to
obtain shorten names. See the details for the structure of the
adopted schema (named "sen2r naming convention").
The function applies only to compact product names (not to single granule
names), since it is thought to be applied to entire products.
Old long names are no more supported.
}
\details{
\href{https://earth.esa.int/web/sentinel/user-guides/sentinel-2-msi/naming-convention}{ESA Sentinel-2 naming convention}
is particularly long-winded.
So, the convention here adopted, named "sen2r naming convention",
follows this schema:

\code{S2mll_yyyymmdd_rrr_ttttt_ppp_rr.fff}

where:
\itemize{
\item \code{S2mll} (length: 5) shows the mission ID (\code{S2A} or \code{S2B}) and the product level
(\verb{1C} or \verb{2A});
\item \code{yyyymmdd} (length: 8) is the sensing date (e.g. \code{20170603} for 2017-06-03) ; the
hour is skipped, since a single sensor can not pass two times in a
day on the same tile);
\item \code{rrr} (length: 3) is the relative orbit number (e.g. \code{022});
\item \code{ttttt} (length: 5) is the tile number (e.g. \verb{32TQQ});
\item \code{ppp} (length: 3) is the output product, being one of these:
\emph{for level 1C:}
\itemize{
\item \code{TOA}: 13-bands Top-Of-Atmosphere Reflectance;
\emph{for level 2A:}
\item \code{BOA}: 13-bands Bottom-Of-Atmosphere Reflectance;
\item \code{TCI}: True Colour Image (3-band RGB 8-bit image);
\item \code{AOT}: Aerosol Optical Thickness;
\item \code{WVP}: Water Vapour;
\item \code{SCL}: Scene Classification Map;
\item \code{CLD}: Quality Indicators for cloud probabilities;
\item \code{SNW}: Quality Indicators for snow probabilities;
\item \code{VIS}: TODO Visibility (used for AOT);
\emph{for both levels:}
\item \code{SZA}: Sun Zenith Angles;
\item \code{SAA}: Sun Azimuth Angles;
\item \code{OZA}: averaged Viewing Incidence Zenith Angles;
\item \code{OAA}: averaged Viewing Incidence Azimuth Angles.
}
\item \code{rr} (length: 2) is the original minimum spatial resolution in metres
(10, 20 or 60);
\item \code{fff} (length: variable, generally 3) is the file extension.
}
}
\note{
License: GPL 3.0
}
\examples{
safe_shortname("S2A_MSIL1C_20170603T101031_N0205_R022_T32TQQ_20170603T101026.SAFE", ext="tif")
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{https://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
