% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2_translate.R
\name{s2_translate}
\alias{s2_translate}
\title{Convert from SAFE format}
\usage{
s2_translate(
  infile,
  outdir = ".",
  subdirs = NA,
  tmpdir = NA,
  rmtmp = TRUE,
  prod_type = NULL,
  tiles = NA,
  res = "10m",
  format = "VRT",
  compress = "DEFLATE",
  bigtiff = FALSE,
  vrt_rel_paths = NA,
  utmzone = "",
  overwrite = FALSE
)
}
\arguments{
\item{infile}{Full path of the input SAFE folder (alternatively,
full path of the xml file of the product with metadata).}

\item{outdir}{(optional) Full name of the output directory where
the files should be created (default: current directory).
\code{outdir} can bot be an existing or non-existing directory (in the
second case, its parent directory must exists).
If it is a relative path, it is expanded from the directory of \code{infile}.}

\item{subdirs}{(optional) Logical: if TRUE, different output products are
placed in separated \code{outdir} subdirectories; if FALSE, they are placed in
\code{outdir} directory; if NA (default), subdirectories are created only if
\code{prod_type} has length > 1.}

\item{tmpdir}{(optional) Path where intermediate files (VRT) will be created.
Default is a temporary directory.
If \code{tmpdir} is a non-empty folder, a random subdirectory will be used.}

\item{rmtmp}{(optional) Logical: should temporary files be removed?
(Default: TRUE).
This parameter takes effect only if the output files are not VRT
(in this case temporary files cannot be deleted, because rasters of source
bands are included within them).}

\item{prod_type}{(optional) Vector of types to be produced as outputs
(see \link{safe_shortname} for the list of accepted values). Default is
reflectance ("TOA" for level 1C, "BOA" for level 2A).}

\item{tiles}{(optional) Character vector with the desired output tile IDs
(id specified IDs are not present in the input SAFE product, they are not
produced). Default (NA) is to process all the found tiles.}

\item{res}{(optional) Spatial resolution (one between '10m', '20m' or '60m');
default is '10m'. Notice that, choosing '10m' or '20m', bands with lower
resolution will be rescaled to \code{res}. Band 08 is used with \code{res = '10m'},
band 08A with \code{res = '20m'} and \code{res = '60m'}.}

\item{format}{(optional) Format of the output file (in a
format recognised by GDAL). Default value is "VRT" (Virtual Raster).}

\item{compress}{(optional) In the case a GTiff format is
chosen, the compression indicated with this parameter is used.}

\item{bigtiff}{(optional) Logical: if TRUE, the creation of a BigTIFF is
forced (default is FALSE).
This option is used only in the case a GTiff format was chosen.}

\item{vrt_rel_paths}{(optional) Logical: if TRUE (default on Linux),
the paths present in the VRT output file are relative to the VRT position;
if FALSE (default on Windows), they are absolute.
This takes effect only with \code{format = "VRT"}.}

\item{utmzone}{(optional) UTM zone of output products (default:
the first one retrieved from input granules),
being a 3-length character (e.g. \code{"32N"}).
Note that this function
does not perform reprojections: if no granules refer to the specified
UTM zone, no output is created.}

\item{overwrite}{Logical value: should existing output files be
overwritten? (default: FALSE)}
}
\value{
A vector with the names of the created output files
(just created or already existing).
}
\description{
The function build a virtual raster from a Sentinel2 SAFE product,
eventually translating it in another spatial format.
For now, only L1C and L2a with long name (< 2016/12/06) are recognised.
Output vrt is at 10m resolution.
}
\note{
License: GPL 3.0
}
\examples{
\dontrun{
s2_l1c_example <- file.path(
  "/existing/path",
  "S2A_MSIL1C_20170603T101031_N0205_R022_T32TQQ_20170603T101026.SAFE")
s2_l1c_example <- file.path(
  "/existing/path",
  "S2A_MSIL2A_20170603T101031_N0205_R022_T32TQQ_20170603T101026.SAFE")

# Create a single TOA GeoTIFF in the same directory
s2_translate(s2_l1c_example, format="GTiff")

# Create a single BOA VRT with a custom name
s2_translate(
  s2_l2a_example,
  "/new/path/example_sentinel2_sr.vrt",
  vrt_rel_paths = TRUE
)

# Create three products (ENVI) in the same directory at 60m resolution
s2_translate(
  s2_example, 
  format = "ENVI", 
  prod_type = c("BOA","TCI","SCL"),
  res = "60m", 
  subdirs = TRUE
)
}
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{http://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
