% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2_defNA.R
\name{s2_defNA}
\alias{s2_defNA}
\title{Set NA value of a specific product type}
\usage{
s2_defNA(prod_types)
}
\arguments{
\item{prod_types}{Character vector of the input product types}
}
\value{
Numeric NA values (NA not to set any NA value), corresponding to
\code{prod_types}.
}
\description{
Internal function to determine the NA value to be used for
each product type (except for spectral indices, whose NA value is
managed by \link{s2_calcindices}).
}
\examples{
sen2r:::s2_defNA("BOA")
sen2r:::s2_defNA(c("BOA","BOA","SCL","TCI"))
}
\author{
Luigi Ranghetti, phD (2019) \email{luigi@ranghetti.info}
}
