% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotParDiffTree.R
\name{plotParDiffTree}
\alias{plotParDiffTree}
\title{Plot parameter differences}
\usage{
plotParDiffTree(
  tree,
  plot = "ballon",
  measure = "wald",
  normalize = FALSE,
  title = TRUE,
  structure = FALSE
)
}
\arguments{
\item{tree}{a semtree object.}

\item{plot}{a character that specifies the plot typ. Available plot types
are "ballon" (default), "heatmap", and "bar".}

\item{measure}{a character. "wald" (default) gives the squared parameter
differences divided by their pooled standard errors. "test" gives the
contributions of the parameters to the test statistic. "raw" gives the
absolute values of the parameter differences.}

\item{normalize}{logical value; if TRUE parameter differences of each split
are divided by sum of all differences the corresponding split. Set to FALSE
by default.}

\item{title}{logical value; if TRUE a title is added to the plot.}

\item{structure}{logical value; if TRUE the structure of the tree is plotted
on the right side.}
}
\description{
Visualizes parameter differences between post-split nodes with
different plot types.
}
\author{
Manuel Arnold
}
