% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavaan_indicator_order.R
\name{lavaan_indicator_order}
\alias{lavaan_indicator_order}
\title{Determine the Order of
Indicators Using a 'lavaan' Model
Syntax}
\usage{
lavaan_indicator_order(model_syntax)
}
\arguments{
\item{model_syntax}{A string that
should be a model specified in
\code{lavaan} model syntax. Only the
factor structure (operator \verb{=~})
in the model will be used.}
}
\value{
A named character vector. The values
are the indicators in the model
syntax. The names are the latent
factors the indicators loaded on.
}
\description{
Determine the order
of indicators and match indicators
and factors based on a 'lavaan'
model syntax.
}
\details{
It generates a named vector
for the argument \code{indicator_order}
of \code{\link[=set_cfa_layout]{set_cfa_layout()}} and
\code{\link[=set_sem_layout]{set_sem_layout()}} using a \code{lavaan}
model syntax.

A variable is considered an indicator
if it is on the right-hand side
of the operator \verb{=~}.

If an indicator loaded on more than
one latent variable, it will only be
matched to one of them, determined
by the order of appearance in the
internal storage.
}
\examples{

mod <-
  'f1 =~ x01 + x02 + x03 + x06
   f4 =~ x11 + x12 + x13 + x14
   f2 =~ x04 + x05 + x06 + x07
   f3 =~ x08 + x09 + x10 + x03
  '
lavaan_indicator_order(mod)

mod <-
  'f1 =~ x01 + x02 + x03 + x06
   f3 =~ x08 + x09 + x10 + x03
   f2 =~ x04 + x05 + x06 + x07
   f4 =~ x11 + x12 + x13 + x14
   f3 ~ f1 + f2
   f4 ~ f3
  '
lavaan_indicator_order(mod)

}
\seealso{
\code{\link[=set_sem_layout]{set_sem_layout()}} and
\code{\link[=set_cfa_layout]{set_cfa_layout()}}.
}
