% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/std_coeff_fun.R
\name{getY}
\alias{getY}
\title{Get Model Response Variable}
\usage{
getY(mod, data = NULL, link = FALSE, ...)
}
\arguments{
\item{mod}{A fitted model object, or a list or nested list of such objects.}

\item{data}{An optional dataset used to first re-fit the model(s).}

\item{link}{Logical. If \code{TRUE}, return the GLM response variable on the
link scale (see Details).}

\item{...}{Arguments to \code{glt} (not including \code{family}, which is
determined from \code{mod}).}
}
\value{
A numeric vector comprising the response variable on the original or
  link scale, or an array, list of vectors/arrays, or nested list.
}
\description{
Extract the response variable from a fitted model on the
  original or link scale.
}
\details{
\code{getY} will return the response variable from a model by
  summing the fitted values and the response residuals. If \code{link = TRUE}
  and the model is a GLM, the response is returned on the link scale. If this
  results in undefined values, it is replaced by an estimate based on the
  'working' response variable of the GLM (see \code{\link[semEff]{glt}}).
}
\examples{
## All SEM responses (original scale)
getY(Shipley.SEM)

## Estimated response in link scale from binomial model
getY(Shipley.SEM$Live, link = TRUE)
}
