% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/navigation.R, R/navigationDoc.R
\name{getCurrentUrl}
\alias{getCurrentUrl}
\title{Retrieve the URL of the current page.}
\usage{
getCurrentUrl(remDr, ...)
}
\arguments{
\item{remDr}{An object of class "rDriver". A remote driver object see \code{\link{remoteDr}}.}

\item{...}{Additonal function arguments - Currently passes the \code{\link{retry}} argument.}
}
\value{
A character string is returned giving the current page URL.
}
\description{
\code{getCurrentUrl} Retrieve the URL of the current page.
}
\examples{
\dontrun{
  remDr <- remoteDr()
  remDr \%>\% go("http://www.google.com/ncr")

  # get the title
  remDr \%>\% getTitle

  # get the current page url
  remDr \%>\% getCurrentUrl

  # navigate
  remDr \%>\% go("http://www.bbc.co.uk")

  # go back
  remDr \%>\% (seleniumPipes::back)

  # go forward
  remDr \%>\% forward

  # refresh page
  remDr \%>\% refresh

  # close browser
  remDr \%>\% deleteSession
}

}
\seealso{
Other navigation functions: \code{\link{back}},
  \code{\link{forward}}, \code{\link{getTitle}},
  \code{\link{go}}, \code{\link{refresh}}
}

