% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global_actions.R
\name{take_screenshot}
\alias{take_screenshot}
\title{Take a screenshot of the current page}
\usage{
take_screenshot(file = NULL, view = FALSE, session = NULL)
}
\arguments{
\item{file}{The file path to save the screenshot to.}

\item{view}{Whether to open the interactively view the screenshot. If this is
\code{TRUE} and \code{file} is \code{NULL}, the screenshot will be deleted after viewing.}

\item{session}{A `selenider_session object. If not specified, the global
session object (the result of \code{\link[=get_session]{get_session()}}) is used.}
}
\value{
\code{file}, if it is not \code{NULL}. Otherwise, the session object is returned, invisibly.
}
\description{
Take a screenshot of the current session state, saving this image to a file.
}
\examples{
\dontshow{if (selenider::selenider_available()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
session <- selenider_session()

open_url("https://www.google.com")

file_path <- withr::local_tempfile(fileext = "png")

take_screenshot(file_path)

\dontshow{
# Clean up all connections and invalidate default chromote object
selenider_cleanup()
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other global actions: 
\code{\link{back}()},
\code{\link{execute_js_fn}()},
\code{\link{get_page_source}()},
\code{\link{open_url}()},
\code{\link{reload}()}
}
\concept{global actions}
