% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R
\name{elem_set_value}
\alias{elem_set_value}
\alias{elem_send_keys}
\alias{elem_clear_value}
\title{Set the value of an input}
\usage{
elem_set_value(x, text, timeout = NULL)

elem_send_keys(x, ..., modifiers = NULL, timeout = NULL)

elem_clear_value(x, timeout = NULL)
}
\arguments{
\item{x}{A \code{selenider_element} object. For \code{\link[=elem_send_keys]{elem_send_keys()}}, this can be \code{NULL},
meaning that the keys will be sent to the current page (or the currently focused
element) instead of a specific element.}

\item{text}{A string to set the value of the input element to.}

\item{timeout}{How long to wait for the element to exist.}

\item{...}{A set of inputs to send to \code{x}.}

\item{modifiers}{A character vector; one or more of "shift", "ctrl"/"control", "alt", and "command"/meta".
Note that when using chromote as a backend, these do not work on Mac OS.}
}
\value{
\code{x}, invisibly.
}
\description{
\code{elem_set_value()} sets the value of an HTML input element to a string.
}
\details{
\code{elem_send_keys()} sends a set of inputs to an element.

\code{elem_clear_value()} sets the value of an HTML element to \code{""}, removing any
existing content.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
html <- "
<input type='text' oninput='recordChange(event)' onkeypress='return checkEnter(event);'>
<p></p>
"

js <- "
function recordChange(e) {
  document.getElementsByTagName('p').item(0).innerText = e.target.value;
}

function checkEnter(e) {
  // If the key pressed was Enter
  if (e.keyCode == 13) {
    document.getElementsByTagName('p').item(0).innerText = 'Enter pressed!';
    return false;
  }
  return true;
}
"

session <- minimal_selenider_session(html, js = js)

elem_expect(s("p"), has_exact_text(""))

input <- s("input")

elem_set_value(input, "my text")

elem_expect(s("p"), has_text("my text"))

elem_clear_value(input)

elem_expect(s("p"), has_exact_text(""))

elem_send_keys(input, keys$enter)

elem_expect(s("p"), has_text("Enter pressed!"))

\dontshow{
# Clean up all connections and invalidate default chromote object
selenider_cleanup()
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other actions: 
\code{\link{elem_click}()},
\code{\link{elem_hover}()},
\code{\link{elem_scroll_to}()},
\code{\link{elem_submit}()}
}
\concept{actions}
