% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{PlotExpectedFitness}
\alias{PlotExpectedFitness}
\title{Function to plot a distribution of fitnesses based on codon equilibrium freqs}
\usage{
PlotExpectedFitness(codon.fitnesses.matrices, codon.eq.matrices, values,
  optimal.aa = NULL, palette = "Set1", lwd = 2,
  include.stop.codon = FALSE, type = "histogram", fitness = TRUE,
  numcode = 1, ...)
}
\arguments{
\item{codon.fitnesses.matrices}{A 3d array of aa.fitness.matrix returned from ComputeEquilibriumAAFitness (first element in return)}

\item{codon.eq.matrices}{A 3d array of codon equilibrium frequencies}

\item{values}{The vector of labels for each matrix (i.e., different Phi values)}

\item{optimal.aa}{Single letter code for the optimal aa. If NULL, integrates across aa.}

\item{palette}{Color palette to use from RColorBrewer}

\item{lwd}{Line width}

\item{include.stop.codon}{Include stop codons}

\item{type}{If "histogram", do a histogram plot; if "density", do a density plot}

\item{fitness}{If TRUE, plot W; if FALSE, plot S (= 1 - W)}

\item{numcode}{The genetic code}

\item{...}{Other paramters to pass to plot()}
}
\description{
Function to plot a distribution of fitnesses based on codon equilibrium freqs
}
