% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/roll_mean.R
\name{roll_mean}
\alias{roll_mean}
\title{Rolling Mean with Alignment}
\usage{
roll_mean(x, n = 7, increment = 1, align = "center")
}
\arguments{
\item{x}{an \R numeric vector}

\item{n}{integer window size}

\item{increment}{integer shift to use when sliding the window to the next location}

\item{align}{window alignment, one of \code{"left"|"center"|"right"}}
}
\value{
A vector of rolling mean values of the same length as \code{x}.
}
\description{
Fast rolling means with aligment using C++/Rcpp.
Additional performance gains can be achieved by skipping \code{increment} values between calculations.
}
\details{
The window size \code{n} is interpreted as the full window length.

Setting \code{increment} to a value greater than one will result in \code{NA}s for all skipped-over indices.

The \code{align} parameter determines the alignment of the current index within the window. Thus:

\itemize{
  \item{\code{align="left" [*------]} will cause the returned vector to have n-1 \code{NA} values at the right end.}
  \item{\code{align="center" [---*---]} will cause the returned vector to have (n-1)/2 \code{NA} values at either end.}
  \item{\code{align="right" [------*]} will cause the returned vector to have n-1 \code{NA} values at the left end.}
}
}
\note{
For \code{align="center"}, the window size is increased by one if necessary to guarantee an odd window size.
}
\examples{
x <- rep(1:5,each=10)
plot(x,cex=0.8,pch=17,main="Test of roll_mean alignment with a 5-point window")
points(roll_mean(x,5,1,'left'),cex=1.5,col='blue',type='b')
points(roll_mean(x,5,1,'center'),cex=1.5,col='forestgreen',type='b')
points(roll_mean(x,5,1,'right'),cex=1.5,col='red',type='b')
legend("topleft",
       legend=c('data','align=left','align=center','align=right'),
       col=c('black','blue','forestgreen','red'),
       pch=c(17,1,1,1))
}

