% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{em_li}
\alias{em_li}
\title{EM algorithm from Li (2011)}
\usage{
em_li(B, itermax = 100L, eps = 1e-05)
}
\arguments{
\item{B}{Matrix of genotype log-likelihoods. The rows index the individuals
and the columns index the genotypes.}

\item{itermax}{The maximum number of iterations.}

\item{eps}{The stopping criteria.}
}
\value{
A vector of log prior probabilities for each genotype.
}
\description{
EM algorithm to estimate prior genotype probabilities from genotype
likelihoods.
}
\examples{
# Simulate some data
set.seed(1)
gl <- simgl(nvec = c(3, 2, 4, 1, 2))
# Run em
lprob <- em_li(B = gl)
# Exponentiate to get probabilities
prob <- exp(c(lprob))
prob

}
\references{
\itemize{
\item{Li, H. (2011). A statistical framework for SNP calling, mutation discovery, association mapping and population genetical parameter estimation from sequencing data. \emph{Bioinformatics}, 27(21), 2987-2993. \doi{10.1093/bioinformatics/btr509}}
}
}
\author{
David Gerard
}
