% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutual.R
\name{mutual_total_nested}
\alias{mutual_total_nested}
\title{Calculate a nested decomposition of segregation for M and H}
\usage{
mutual_total_nested(data, group, unit, weight = NULL, base = exp(1))
}
\arguments{
\item{data}{A data frame.}

\item{group}{A categorical variable or a vector of variables
contained in \code{data}. Defines the first dimension
over which segregation is computed.}

\item{unit}{A vector of variables
contained in \code{data}. Defines the levels at which
the decomposition should be computed.}

\item{weight}{Numeric. (Default \code{NULL})}

\item{base}{Base of the logarithm that is used in the calculation.
Defaults to the natural logarithm.}
}
\value{
Returns a data.table similar to \code{\link{mutual_total}},
  but with column \code{between} and \code{within} that define
  the levels of nesting.
}
\description{
Returns the between-within decomposition defined by
the sequence of variables in \code{unit}.
}
\examples{
mutual_total_nested(schools00, "race", c("state", "district", "school"),
    weight = "n"
)
# This is a simpler way to run the following manually:
# mutual_total(schools00, "race", "state", weight = "n")
# mutual_total(schools00, "race", "district", within = "state", weight = "n")
# mutual_total(schools00, "race", "school", within = c("state", "district"), weight = "n")
}
