% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_prepare.R
\name{check_repetition}
\alias{check_repetition}
\title{Check for exact repetition in the series}
\usage{
check_repetition(x, lmin)
}
\arguments{
\item{x}{the bivariate series to be tested}

\item{lmin}{minimum length of segment}
}
\value{
a boolean, TRUE if there is any repetition larger or equal to lmin.
}
\description{
\code{check_repetition} checks whether the series have exact repetition larger than lmin.
if that is the case, throw an error, the algorithm cannot yet handle these repetition,
because variance on the segment would be null.
}
\examples{
set.seed(42) 
dat <- rbind(base::sample(seq(1,10),  size= 100, replace = TRUE),
             base::sample(seq(1,10),  size= 100, replace = TRUE))
check_repetition(dat, lmin = 3)
check_repetition(dat, lmin = 5)             
}
