% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SETTINGS.R
\name{SETTINGS}
\alias{SETTINGS}
\title{Automatic Calculation of optimal Initial Parameters}
\usage{
SETTINGS(
  VARIANCE,
  N,
  BETA_LAMDBA,
  alphainit,
  betainit,
  R = c(1000, 1000),
  ROH = c(10, 10)
)
}
\arguments{
\item{VARIANCE}{standard error of the observed stat dynamics (per time point)}

\item{N}{number of system states}

\item{BETA_LAMDBA}{mcmc tuning parameter (weighting of observed states)}

\item{alphainit}{mcmc tuning parameter (weighting of observed states)}

\item{betainit}{mcmc tuning parameter (weighting of observed states)}

\item{R}{mcmc tuning parameter}

\item{ROH}{mcmc tuning parameter}
}
\value{
A list of optimal initial parameters; i.e. R, Roh, Alpha, Beta, Tau, Lambda1, Lambda2
}
\description{
Implemented according to Engelhardt et al. 2017.
}
\details{
The function can be replaced by an user defined version if necessary.
}
