% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIBBS_update.R
\name{GIBBS_update}
\alias{GIBBS_update}
\title{Gibbs Update}
\usage{
GIBBS_update(D, EPS_inner, R, ROH, SIGMA_0, n, SIGMA, LAMBDA2, LAMBDA1, TAU)
}
\arguments{
\item{D}{diagonal weight matrix of the current Gibbs step}

\item{EPS_inner}{row-wise vector of current hidden influences [tn,tn+1]}

\item{R}{parameter for needed for the Gibbs update (for details see Engelhardt et al. 2017)}

\item{ROH}{parameter for needed for the Gibbs update (for details see Engelhardt et al. 2017)}

\item{SIGMA_0}{prior variance of the prior for the hidden influences}

\item{n}{number of system states}

\item{SIGMA}{current variance of the prior for the hidden influences (calculated during the Gibbs update)}

\item{LAMBDA2}{current parameter (smoothness) needed for the Gibbs update (for details see Engelhardt et al. 2017)}

\item{LAMBDA1}{current parameter (sparsity)  needed for the Gibbs update (for details see Engelhardt et al. 2017)}

\item{TAU}{current parameter (smoothness) needed for the Gibbs update (for details see Engelhardt et al. 2017)}
}
\value{
A list of updated Gibbs parameters; i.e. Sigma, Lambda1, Lambda2, Tau
}
\description{
Algorithm implemented according to Engelhardt et al. 2017. The BDEN defines a conditional Gaussian prior 
over each hidden input. The scale of the variance of the Gaussian prior is a strongly decaying and smooth 
distribution peaking at zero, which depends on parameters Lambda2, Tau and Sigma. The parameter Tau is itself 
given by an exponential distribution (one for each component of the hidden influence vector) with parameters 
Lambda1. In consequence, sparsity is dependent on the parameter vector Lambda1, whereas smoothness is 
mainly controlled by Lambda2. These parameters are drawn from hyper-priors, which can be set in a non-informative 
manner or with respect to prior knowledge about the degree of shrinkage and smoothness of the hidden influences (Engelhardt et al. 2017).
}
\details{
The function can be replaced by an user defined version if necessary
}
