% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lineplot.R
\name{lineplot}
\alias{lineplot}
\title{Graph: line chart}
\usage{
lineplot(
  dados,
  trat,
  nrep,
  time,
  ylab = "Emergence",
  xlab = "Time (days)",
  nt = NA,
  percentage = FALSE,
  legend.position = c(0.2, 0.8)
)
}
\arguments{
\item{dados}{data.frame containing the responses of the evaluations in separate columns side by side and without the columns with the identification of the factors}

\item{trat}{vector of treatments with n repetitions}

\item{nrep}{Number of repetitions}

\item{time}{vector containing time}

\item{ylab}{y-axis name}

\item{xlab}{x-axis name}

\item{nt}{total seeds per repetition}

\item{percentage}{y scale in percentage}

\item{legend.position}{Legend position}
}
\value{
Returns a graph with the frequencies of germinated or emerged seeds.
}
\description{
Returns a graph with the frequencies of germinated or emerged seeds
}
\examples{
data("substrate")
lineplot(substrate[,c(3:18)],
      trat = substrate$Trat,
      nrep = 4,
      time = 1:16)
}
