% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LM_function.R
\name{LM_model}
\alias{LM_model}
\title{Analysis: Linear regression graph}
\usage{
LM_model(
  trat,
  resp,
  ylab = "Germination (\%)",
  error = "SE",
  xlab = expression("Temperature ("^"o" * "C)"),
  grau = NA,
  theme = theme_classic(),
  cardinal = 0,
  legend.position = "top",
  width.bar = NA,
  scale = "none"
)
}
\arguments{
\item{trat}{Numerical vector with treatments (Declare as numeric)}

\item{resp}{Numerical vector containing the response of the experiment.}

\item{ylab}{Dependent variable name (Accepts the \emph{expression}() function)}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{xlab}{Independent variable name (Accepts the \emph{expression}() function)}

\item{grau}{Degree of the polynomial (1,2 or 3)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{cardinal}{Defines the value of y considered extreme (\emph{default} considers 0 germination)}

\item{legend.position}{Legend position (\emph{default} is "top")}

\item{width.bar}{Bar width}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}
}
\value{
The function returns the coefficients and respective p-values; statistical parameters such as AIC, BIC, R2, VIF; cardinal and optimal temperature and the graph using ggplot2 with the equation.
}
\description{
Linear regression analysis of an experiment with a quantitative factor or isolated effect of a quantitative factor
}
\note{
if the maximum predicted value is equal to the maximum x, the curve does not have a maximum point within the studied range. If the minimum value is less than the lowest point studied, disregard the value.
}
\examples{
library(seedreg)
data("aristolochia")
attach(aristolochia)

#================================
# Germination
#================================
LM_model(trat,germ, grau=3)

#================================
# Germination speed
#================================
LM_model(trat, vel, grau=3,
ylab=expression("v"~(dias^-1)))
}
\author{
Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
\keyword{linear}
\keyword{regression}
