% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CD_function.R
\name{CD_model}
\alias{CD_model}
\title{Analysis: Logistic regression Cedergreen-Ritz-Streibig model}
\usage{
CD_model(
  trat,
  resp,
  npar = "CRS.4",
  error = "SE",
  ylab = "Germination (\%)",
  xlab = expression("Temperature ("^"o" * "C)"),
  theme = theme_classic(),
  legend.position = "top",
  cardinal = 0,
  r2 = "all",
  width.bar = NA,
  scale = "none"
)
}
\arguments{
\item{trat}{Numerical or complex vector with treatments}

\item{resp}{Numerical vector containing the response of the experiment.}

\item{npar}{Number of model parameters}

\item{error}{Error bar (It can be SE - \emph{default}, SD or FALSE)}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{legend.position}{legend position (\emph{default} is c(0.3,0.8))}

\item{cardinal}{defines the value of y considered extreme (\emph{default} considers 0 germination)}

\item{r2}{coefficient of determination of the mean or all values (\emph{default} is all)}

\item{width.bar}{bar width}

\item{scale}{Sets x scale (\emph{default} is none, can be "log")}
}
\value{
The function returns the coefficients and respective p-values; statistical parameters such as AIC, BIC, pseudo-R2, RMSE (root mean squared error); cardinal and optimal temperatures and the graph using ggplot2 with the equation.
}
\description{
The 'CRS.4' and 'CRS.5' logistical models provide Brain-Cousens modified logistical models to describe u-shaped hormesis. This model was extracted from the 'drc' package and adapted for temperature analysis in seed germination
}
\details{
The four-parameter model is given by the expression:

\deqn{f(x) = 0 + \frac{d-0+f \exp(-1/x)}{1+\exp(b(\log(x)-\log(e)))}}

while the five-parameter is:

\deqn{f(x) = c + \frac{d-c+f \exp(-1/x)}{1+\exp(b(\log(x)-\log(e)))}}
}
\note{
if the maximum predicted value is equal to the maximum x, the curve does not have a maximum point within the studied range. If the minimum value is less than the lowest point studied, disregard the value.
}
\examples{
library(seedreg)
data("aristolochia")
attach(aristolochia)

#================================
# Germination
#================================
CD_model(trat,germ)

#================================
# Germination speed
#================================
CD_model(trat, vel, ylab=expression("v"~(dias^-1)))
}
\references{
Seber, G. A. F. and Wild, C. J (1989) Nonlinear Regression, New York: Wiley \& Sons (p. 330).

Ritz, C.; Strebig, J.C.; Ritz, M.C. Package 'drc'. Creative Commons: Mountain View, CA, USA, 2016.
}
\author{
Model imported from the drc package (Ritz et al., 2016)

Gabriel Danilo Shimizu

Leandro Simoes Azeredo Goncalves
}
