% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.check_predictions.R
\name{print.see_performance_pp_check}
\alias{print.see_performance_pp_check}
\alias{plot.see_performance_pp_check}
\title{Plot method for posterior predictive checks}
\usage{
\method{print}{see_performance_pp_check}(
  x,
  size_line = 0.5,
  size_point = 2,
  size_bar = 0.7,
  size_axis_title = base_size,
  size_title = 12,
  base_size = 10,
  line_alpha = 0.15,
  style = theme_lucid,
  colors = unname(social_colors(c("green", "blue"))),
  type = c("density", "discrete_dots", "discrete_interval", "discrete_both"),
  x_limits = NULL,
  ...
)

\method{plot}{see_performance_pp_check}(
  x,
  size_line = 0.5,
  size_point = 2,
  size_bar = 0.7,
  size_axis_title = base_size,
  size_title = 12,
  base_size = 10,
  line_alpha = 0.15,
  style = theme_lucid,
  colors = unname(social_colors(c("green", "blue"))),
  type = c("density", "discrete_dots", "discrete_interval", "discrete_both"),
  x_limits = NULL,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{size_line}{Numeric value specifying size of line geoms.}

\item{size_point}{Numeric specifying size of point-geoms.}

\item{size_bar}{Size of bar geoms.}

\item{base_size, size_axis_title, size_title}{Numeric value specifying size of
axis and plot titles.}

\item{line_alpha}{Numeric value specifying alpha of lines indicating \code{yrep}.}

\item{style}{A ggplot2-theme.}

\item{colors}{Character vector of length two, indicating the colors (in
hex-format) for points and line.}

\item{type}{Plot type for the posterior predictive checks plot. Can be \code{"density"}
(default), \code{"discrete_dots"}, \code{"discrete_interval"} or \code{"discrete_both"} (the
\verb{discrete_*} options are appropriate for models with discrete - binary, integer
or ordinal etc. - outcomes).}

\item{x_limits}{Numeric vector of length 2 specifying the limits of the x-axis.
If not \code{NULL}, will zoom in the x-axis to the specified limits.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{performance::check_predictions()} function.
}
\examples{
library(performance)

model <- lm(Sepal.Length ~ Species * Petal.Width + Petal.Length, data = iris)
check_predictions(model)

# dot-plot style for count-models
d <- iris
d$poisson_var <- rpois(150, 1)
model <- glm(
  poisson_var ~ Species + Petal.Length + Petal.Width,
  data = d,
  family = poisson()
)
out <- check_predictions(model)
plot(out, type = "discrete_dots")
}
\seealso{
See also the vignette about \href{https://easystats.github.io/performance/articles/check_model.html}{\code{check_model()}}.
}
