% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.si.R
\name{plot.see_si}
\alias{plot.see_si}
\title{Plot method for support intervals}
\usage{
\method{plot}{see_si}(
  x,
  si_color = "#0171D3",
  si_alpha = 0.2,
  show_intercept = FALSE,
  support_only = FALSE,
  ...
)
}
\arguments{
\item{x}{An object.}

\item{si_color}{Character specifying color of SI ribbon.}

\item{si_alpha}{Numeric value specifying Transparency level of SI ribbon.}

\item{show_intercept}{Logical, if \code{TRUE}, the intercept-parameter is included
in the plot. By default, it is hidden because in many cases the
intercept-parameter has a posterior distribution on a very different
location, so density curves of posterior distributions for other parameters
are hardly visible.}

\item{support_only}{Logical. Decides whether to plot only the support data,
or show the "raw" prior and posterior distributions? Only applies when
plotting \code{\link[bayestestR:si]{bayestestR::si()}}.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A ggplot2-object.
}
\description{
The \code{plot()} method for the \code{bayestestR::si()}.
}
\examples{
\dontshow{if (require("rstanarm")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
library(rstanarm)
library(bayestestR)
set.seed(123)
m <<- stan_glm(Sepal.Length ~ Petal.Width * Species, data = iris, refresh = 0)
result <- si(m)
result
plot(result)
}
\dontshow{\}) # examplesIf}
}
