% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plots}
\alias{plots}
\title{Multiple plots side by side}
\usage{
plots(..., n_rows = NULL, n_columns = NULL, tags = FALSE)
}
\arguments{
\item{...}{grobs, gtables, ggplot or trellis objects}

\item{n_rows}{Number of rows to align plots.}

\item{n_columns}{Number of columns to align plots.}

\item{tags}{Add tags to your subfigures. Can be \code{FALSE} (no tags), \code{TRUE} (letter tags) or character vector containing tags labels.}
}
\description{
A wrapper around gridExtra::grid.arrange to plot multiple figures side by side on the same page.
}
\examples{
library(ggplot2)
library(see)

p1 <- ggplot(iris, aes(x = Petal.Length, y = Sepal.Width)) + geom_point()
p2 <- ggplot(iris, aes(x = Petal.Length)) + geom_density()

plots(p1, p2)
plots(p1, p2, n_columns = 2, tags = TRUE)
plots(p1, p2, n_columns = 2, tags = c("Fig. 1", "Fig. 2"))

}
