% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_date.R
\name{export_datetime}
\alias{export_datetime}
\alias{export_date}
\title{Return the date and time that an export was performed}
\usage{
export_datetime(x)

export_date(x)
}
\arguments{
\item{x}{secuTrial export}
}
\value{
\code{export_date} returns a date object, \code{export_datetime} returns a string
}
\description{
Return the date and time that an export was performed
}
\examples{
export_location <- system.file("extdata", "sT_exports", "lnames",
                               "s_export_CSV-xls_CTU05_long_ref_miss_en_utf8.zip",
                               package = "secuTrialR")
# read all export data
sT_export <- read_secuTrial(data_dir = export_location)
# get date/time
export_datetime(sT_export)
export_date(sT_export)
}
