% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadCalculations.R
\name{loadCalculations}
\alias{loadCalculations}
\title{Calculate annual loads and summarize trends}
\format{
The first data frame returned has one row for each pesticide-year at
a particular site and four columns. The general format is as follows: \cr
\tabular{lll}{
 pstaid \tab character \tab the station identification number \cr
 pcode \tab character \tab the parameter code for which a load was calculated\cr
 year or wyear \tab numeric \tab the year or water year for which a load was calculated \cr
 load \tab numeric \tab the load in kilograms per year \cr
}
The second data frame returned has one row for each pesticide at
a particular site and 11 columns. The general format is as follows: \cr
\tabular{lll}{
 pcode \tab character \tab the parameter code for which a load trend was calculated\cr
 mclass \tab numeric \tab a value of 1 or 2\cr
 mclass \tab numeric \tab a value of 1 or 2\cr
 alpha \tab numeric \tab a significance level \cr
 ltndPpor \tab numeric \tab the load trend in percent over the period of record \cr
 luciPpor \tab numeric \tab the load upper confidence interval for the trend in\cr
  \tab \tab percent over the period of record \cr
 llciPpor \tab numeric \tab the load lower confidence interval for the trend in\cr
  \tab \tab percent over the period of record \cr
 baseLoad \tab numeric \tab the base load, the load for the first year of trend period \cr
 ltndOrigPORPercentBase \tab numeric \tab the load trend in original units over\cr
  \tab \tab the period of record\cr
  \tab \tab (calculation based on percent per year and base load)\cr
 luciOrigPORPercentBase \tab numeric \tab the load trend upper confidence interval\cr
  \tab \tab for the trend in original units over the period of record\cr
  \tab \tab (calculation based on percent per year and base load)\cr
 llciOrigPORPercentBase \tab numeric \tab the load trend lower confidence interval\cr
  \tab \tab for the trend in original units over the period of record\cr
  \tab \tab (calculation based on percent per year and base load)\cr
 ltndlklhd \tab numeric \tab is the load trend likelihood \cr
}
}
\usage{
loadCalculations(
  dailyDat,
  pestPredict,
  modRes,
  concTrends,
  yrtype = 1,
  alpha = 0.1
)
}
\arguments{
\item{dailyDat}{is the daily streamflow data in the form of a data frame
with three columns representing a station ID, date, and streamflow.}

\item{pestPredict}{is the continuous (daily) estimation of pesticide
concentrations for one or more pesticides at a single site. This should be
in the form of the fourth element of the list returned by \code{fitswavecav}.}

\item{modRes}{is the first element of the list returned by \code{fitswavecav} 
and includes the scale parameter for one or more pesticide trend models at
a single site. The scale parameter is used in the bias correction.}

\item{concTrends}{the SEAWAVE-Q trend in flow-normalized annual load. Cannot 
be different (computationally) from the trend in flow-normalized annual 
concentration when there is no trend in flow (Oelsner and others, 2017).}

\item{yrtype}{allows one to calculate annual loads based on a calendar 
year or a water year, where a water year is the 12-month period October 1 
through September 30 designated by the calendar year in which it ends. A 
yrtype of 1 represents a calendar year and is the default because that
is the way the original model was developed. A yrtype of 2 represents a
water year.}

\item{alpha}{is the significance level or alpha value for statistical
significance and confidence intervals.}
}
\value{
Two data frames, the first contains the annual loads, the second
contains the trend summary.
}
\description{
Function to calculate pesticide loads in kilograms per year and summarize trends.
}
\details{
Parameter load (mass) is the product of water-quality concentration 
(a mass per volume) and an associated streamflow rate (volume per time). This
function generates an annual time series of pesticide loads on either a
calendar year basis or a water year basis and summarizes load trends.
}
\note{
In this load calculation function, daily pesticide concentration 
estimates provided by the \code{fitswavecav} function are corrected for 
retransformation bias (the concentration model is built on the base-10 
logarithm of concentration; therefore, a bias correction is required when 
transforming back to the original units) and then used to calculate daily 
loads. The bias correction is based on the quasi-maximum likelihood estimator 
(Cohn and others, 1989) that was developed for natural logarithms, with an 
adjustment for the base-10 logarithm of the concentration. To calculate 
loads, the bias-corrected concentration estimates (assumed to be in 
micrograms per liter) are multiplied by daily streamflow and a constant, 
0.892998605, which converts the load units 
(micrograms per liter * cubic feet per second) to kilograms per year. 
Daily loads are summed to annual values. See page 70 and equation 26 of 
Oelsner and others (2017) for further details regarding the load 
calculation and bias correction.
Users may modify this function to convert to units other than kilograms
per year.
}
\examples{
data(swData)
modMoRivOmaha <- combineData(qwdat = qwMoRivOmaha, cqwdat = cqwMoRivOmaha)
myfit1 <- fitswavecav(cdat = modMoRivOmaha, cavdat = cqwMoRivOmaha, 
tanm = "myfit1", pnames = c("04035", "04037", "04041"), yrstart = 1995, 
yrend = 2003, tndbeg = 1995, tndend = 2003, iwcav = c("flowa30", "flowa1"), 
dcol = "dates", qwcols = c("R", "P"))
MoRivOmahaLoadsYr <- loadCalculations(cqwMoRivOmaha[, 1:3], myfit1[[4]], 
myfit1[[1]], myfit1[[6]])
MoRivOmahaLoadsYr
}
\references{
Cohn, T.A., DeLong, L.L., Gilroy, E.J., Hirsch, R.M., and Wells, D.K., 1989, 
Estimating constituent loads: Water Resources Research, v. 25, no. 5, 
p. 937--942.

Oelsner, G.P., Sprague, L.A., Murphy, J.C., Zuellig, R.E., Johnson, H.M., 
Ryberg, K.R., Falcone, J.A., Stets, E.G., Vecchia, A.V., Riskin, M.L., 
De Cicco, L.A., Mills, T.J., and Farmer, W.H., 2017, Water-quality trends in 
the Nation's rivers and streams, 1972--2012---Data preparation, statistical 
methods, and trend results (ver. 2.0, October 2017): U.S. Geological Survey 
Scientific Investigations Report 2017--5006, 136 p., 
\url{https://doi.org/10.3133/sir20175006}.
}
\author{
Karen R. Ryberg
}
\keyword{datagen}
\keyword{ts}
