% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning_seasonality.r
\name{binning_seasonality}
\alias{binning_seasonality}
\title{Function for monthly binning based clumped isotope seasonality
reconstruction.}
\usage{
binning_seasonality(
  d18Oc,
  D47,
  ages,
  SD_d18Oc = 0.1,
  SD_D47 = 0.04,
  N = 1000,
  binsize = "month",
  d18O_fun = "KimONeil97",
  D47_fun = "Bernasconi18",
  export = FALSE
)
}
\arguments{
\item{d18Oc}{Vector containing subannually resolved \eqn{\delta^{18}O_{c}}{δ18Oc}
data}

\item{D47}{Vector containing subannually resolved \eqn{\Delta_{47}}{Δ47} data}

\item{ages}{Vector containing ages for of all samples in years relative to
the shell chronology}

\item{SD_d18Oc}{Error on the \eqn{\delta^{18}O_{c}}{δ18Oc} measurements.
Either a single value
(constant uncertainty) or a vector of length equal to the period in SST data
(365 days by default) containing information about the error of each
datapoint (1 standard deviation; default = 0.1 permille).}

\item{SD_D47}{Error on the \eqn{\Delta_{47}}{Δ47} measurements. Either a
single value
(constant uncertainty) or a vector of length equal to the period in SST data
(365 days by default) containing information about the error of each
datapoint (1 standard deviation; default = 0.04 permille).}

\item{N}{Number of datapoints for Monte Carlo simulation (defaults to 1000)}

\item{binsize}{Size of the bins in which records are subdivided. \code{month}
and \code{season} (period of three months) is currently supported.}

\item{d18O_fun}{String containing the name of the transfer function used to
convert temperature and \eqn{\delta^{18}O_{w}}{δ18Ow} to
\eqn{\delta^{18}O_{c}}{δ18Oc} data (for example: \code{"KimONeil97"} or
\code{"GrossmanKu86"}). Defaults to Kim and O'Neil (1997).}

\item{D47_fun}{String containing the name of the transfer function used to
convert temperature to \eqn{\Delta_{47}}{Δ47} data (for example:
\code{"Bernasconi18"} or \code{"Jautzy20"}). Defaults to Bernasconi et al.,
2018).}

\item{export}{Export table summary of result (CSV format)? \code{TRUE/FALSE}}
}
\value{
A data frame containing monthly reconstructions of \eqn{\Delta_{47}}{Δ47},
temperature, \eqn{\delta^{18}O}{δ18O} of the precipitation fluid and
\eqn{\delta^{18}O_{c}}{δ18Oc}.
}
\description{
Combines records of stable oxygen isotope ratios (\eqn{\delta^{18}O_{c}}{δ18Oc})
and clumped isotope ratios (\eqn{\Delta_{47}}{Δ47}) through subannually
resolved carbonate archives (e.g. mollusk shells or corals) to reconstruct
monthly variability in temperature and salinity (through the \eqn{\delta^{18}O}{δ18O}
composition of the precipitation fluid), using the monthly binning method
detailed in de Winter et al., 2020 (Climate of the Past).
}
\examples{
# find attached dummy data
Case1 <- seasonalclumped::Case1
d18Oc <- Case1[, 29]
d18Oc <- d18Oc[-which(is.na(d18Oc))]
D47 <- Case1[, 30]
D47 <- D47[-which(is.na(D47))]
ages <- Case1[, 27]
ages <- ages[-which(is.na(ages))]
# Run function
binned <- binning_seasonality(d18Oc,
D47,
ages,
0.1,
0.04,
100, # Use small amount of samples for quick testing (recommended N = 1000)
"month",
"KimONeil97",
"Bernasconi18",
FALSE)
}
\references{
Grossman, E.L., Ku, T., Oxygen and carbon isotope fractionation
in biogenic aragonite: temperature effects, \emph{Chemical Geology} \strong{1986},
\emph{59.1}, 59–74.
\url{https://doi.org/bvpzws}

Kim, S., O'Niel, J.R., Equilibrium and nonequilibrium oxygen
isotope effects in synthetic carbonates, \emph{Geochimica et Cosmochimica Acta}
\strong{1997}, \emph{61.16}, 3461–3475.
\url{https://doi.org/c7bwbp}

Dettman, D.L., Reische, A.K., Lohmann, K.C., Controls on the stable isotope
composition of seasonal growth bands in aragonitic fresh–water bivalves
(Unionidae), \emph{Geochimica et Cosmochimica Acta} \strong{1999}, \emph{63.7–8}, 1049–1057.
\url{https://doi.org/cbb7zc}

Brand, W.A., Coplen, T.B., Vogl, J., Rosner, M., Prohaska, T., Assessment of
international reference materials for isotope–ratio analysis (IUPAC Technical
Report), \emph{Pure and Applied Chemistry} \strong{2014}, \emph{86.3}, 425–467.
\url{https://doi.org/fpc2}

Kele, S., Breitenbach, S. F., Capezzuoli, E., Meckler, A. N., Ziegler, M.,
Millan, I. M., Kluge, T., Deák, J., Hanselmann, K. and John, C. M.,
Temperature dependence of oxygen– and clumped isotope fractionation in
carbonates: a study of travertines and tufas in the 6–95 C temperature range,
\emph{Geochimica et Cosmochimica Acta} \strong{2015}, 168, 172–192.
\url{https://doi.org/f7sgn6}

Bernasconi, S.M., Müller, I.A., Bergmann, K.D., Breitenbach, S.F., Fernandez,
A., Hodell, D.A., Jaggi, M., Meckler, A.N., Millan, I. and Ziegler, M.,
Reducing uncertainties in carbonate–clumped isotope analysis through
consistent carbonate based standardization. \emph{Geochemistry, Geophysics,
Geosystems} \strong{2018}, 19–9, 2895–2914.
\url{https://doi.org/gfmjrw}

Petersen, S. V., Defliese, W. F., Saenger, C., Daëron, M., Huntington, K. W.,
John, C. M., Kelson, J. R., Bernasconi, S. M., Colman, A. S., Kluge, T.,
Olack, G. A., Schauer, A. J., Bajnai, D., Bonifacie, M., Breitenbach, S. F.
M., Fiebig, J., Fernandez, A. B., Henkes, G. A., Hodell, D., Katz, A., Kele,
S., Lohmann, K. C., Passey, B. H., Peral, M. Y., Petrizzo, D. A., Rosenheim,
B. E., Tripati, A., Venturelli, R., Young, E. D. and Winkelstern, I. Z.,
Effects of Improved 17O Correction on Interlaboratory Agreement in Clumped
Isotope Calibrations, Estimates of Mineral–Specific Offsets, and Temperature
Dependence of Acid Digestion Fractionation, \emph{Geochemistry, Geophysics,
Geosystems} *\emph{2019}, 20–7, 3495–3519.
\url{https://doi.org/ggrc39}

Jautzy, J. J., Savard, M. M., Dhillon, R. S., Bernasconi, S. M. and Smirnoff,
A., Clumped isotope temperature calibration for calcite: Bridging theory and
experimentation, \emph{Geochemical Perspectives Letters} \strong{2020}, 14, 36–41.
\url{https://doi.org/fpc3}

de Winter, N. J., Agterhuis, T., Ziegler, M., Optimizing sampling strategies
in high–resolution paleoclimate records, \emph{Climate of the Past Discussions}
\strong{2020}, 1–52.
\url{https://doi.org/fpc4}
}
