### Plot the results of the non-linear test



#' Plot the Results of the Non-linear Test
#' 
#' Creates a contour plot of the region of the third-order moment outside the
#' test limits generated by \code{nonlintest}.
#' 
#' 
#' @param x a \code{nonlintest} object produced by \code{nonlintest}.
#' @param plot display plot (TRUE) or return plot (FALSE)
#' @param \dots additional arguments to \code{plot}
#' @author Adrian Barnett \email{a.barnett<at>qut.edu.au}
#' @seealso \code{nonlintest}
#' @export 
plot.nonlintest<-function(x, plot=TRUE, ...){

  z <- NULL # Setting some variables to NULL first (for R CMD check)

  ## Check
  if (class(x) != "nonlintest"){
    stop("Object must be of class 'nonlintest'")
  }

if(max(abs(x$region))==0){cat('No points of the third-order moment exceed the test limits\n')}

  # Plot (only points that exceed limits)
if(max(abs(x$region))!=0){
   counter=0;
   for(r in 0:x$n.lag){
      for(s in r:x$n.lag){
         frame=data.frame(r=r,s=s,z=x$region[r+1,s+1]);
         if(counter==0){for.plot=frame}else{for.plot=rbind(for.plot,frame)}
		 counter=counter+1;
      }
   }

     gplot=ggplot(for.plot, aes(r, s, z = z))+
           stat_contour()+
           geom_tile(aes(fill = z))
     if(plot==FALSE){return(gplot)}
     if(plot==TRUE){print(gplot)}
 #zlab='Area outside the test limits', ...)
 #  mtext(side=3,'Points of 3rd order moment that exceed limits');
} # end of if
} # end of function

