% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{seagull_bisection}
\alias{seagull_bisection}
\title{Internal bisection algorithm}
\usage{
seagull_bisection(
  ROWS,
  ALPHA,
  LEFT_BORDER,
  RIGHT_BORDER,
  GROUP_WEIGHT,
  VECTOR_WEIGHTS,
  VECTOR_IN
)
}
\arguments{
\item{ROWS}{the length of the input vectors.}

\item{ALPHA}{mixing parameter of the penalty terms. Satisfies: \eqn{0 <
\alpha < 1}. The penalty term looks as follows: \deqn{\alpha *
"lasso penalty" + (1-\alpha) * "group lasso penalty".}}

\item{LEFT_BORDER}{value of the left border of the current interval that
for sure harbors a root.}

\item{RIGHT_BORDER}{value of the right border of the current interval that
for sure harbors a root.}

\item{GROUP_WEIGHT}{a multiplicative scalar which is part of the polynomial.}

\item{VECTOR_WEIGHTS}{an input vector of multiplicative scalars which are
part of the polynomial. This vector is a subset of the vector of weights for
features.}

\item{VECTOR_IN}{another input vector which is required to compute the value
of the polynomial.}
}
\value{
If a certain precision (\code{TOLERANCE}) is reached, this algorithm
returns the center point of the current interval, in which the root is
located. Otherwise, the function calls itself using half of the initial
interval, in which the root is surely located.
}
\description{
This algorithm finds the smallest positive root of a polynomial
of second degree in \eqn{\lambda}. Bisection is an implicit algorithm, i.e.,
it calls itself until a certain precision is reached.
}
\details{
The polynomial has the following form:
\deqn{\sum_j (|vector_j| - \alpha weight_j \lambda )^2_+ - (1 - \alpha)^2
weight^2 \lambda^2.} The polynomial is non-trivial, because summands are
part of the sum if and only if the terms are non-negative.
}
