% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{getcells}
\alias{getcells}
\title{Get list of cells in a given shape}
\usage{
getcells(shape, check_wkt = FALSE, ...)
}
\arguments{
\item{shape}{(character) WKT representation of SRID 4326
polygon/multipolygon}

\item{check_wkt}{(logical) validate WKT or not. Default: \code{FALSE}}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
list of cell ids
}
\description{
Get list of cells in a given shape
}
\examples{
getcells("POLYGON ((-48.177685950413291 15.842380165289299,
-48.177685950413291 15.842380165289299,
-54.964876033057919 28.964280991735578,
-35.960743801652967 27.606842975206646,
-48.177685950413291 15.842380165289299))")

wkt <- "POLYGON((2.37 43.56,13.18 43.56,13.18 35.66,2.37 35.66,2.37 43.56))"
getcells(wkt)

wkt <-
"MULTIPOLYGON(((15 5,5 10,10 20,40 10,15 5)),((30 20,10 40,45 40,30 20)))"
getcells(wkt)
}
