/*
 * Decompiled with CFR 0.152.
 */
package org.ddahl.sdols.featureallocation;

import org.apache.commons.math3.linear.AbstractRealMatrix;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.ddahl.sdols.CrossCompatibility$;
import org.ddahl.sdols.featureallocation.Feature;
import org.ddahl.sdols.featureallocation.Feature$;
import org.ddahl.sdols.featureallocation.FeatureAllocation;
import org.ddahl.sdols.featureallocation.FeatureAllocation$;
import org.ddahl.sdols.featureallocation.FeatureAllocationSummary$;
import org.ddahl.sdols.featureallocation.FeatureAllocationSummary$$anonfun$org$ddahl$sdols$featureallocation$FeatureAllocationSummary$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenIterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.parallel.ParIterableLike;
import scala.collection.parallel.immutable.ParVector$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering;
import scala.math.Ordering$Double$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Random;

public final class FeatureAllocationSummary$ {
    public static final FeatureAllocationSummary$ MODULE$;
    private final Ordering$Double$ ordering;

    static {
        new FeatureAllocationSummary$();
    }

    public Ordering$Double$ ordering() {
        return this.ordering;
    }

    public <A> double[][] expectedPairwiseAllocationMatrix(Seq<FeatureAllocation<A>> fas) {
        if (fas.isEmpty()) {
            throw new IllegalArgumentException("'candidates' cannot be empty.");
        }
        int nItems = ((FeatureAllocation)fas.head()).nItems();
        Array2DRowRealMatrix zero = new Array2DRowRealMatrix(nItems, nItems);
        return ((AbstractRealMatrix)((ParIterableLike)ParVector$.MODULE$.apply(fas)).aggregate((Function0)new Serializable(zero){
            public static final long serialVersionUID = 0L;
            private final Array2DRowRealMatrix zero$1;

            public final Array2DRowRealMatrix apply() {
                return this.zero$1;
            }
            {
                this.zero$1 = zero$1;
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Array2DRowRealMatrix apply(Array2DRowRealMatrix sum, FeatureAllocation<A> x) {
                return sum.add(new Array2DRowRealMatrix((double[][])Predef$.MODULE$.refArrayOps((Object[])x.pairwiseAllocationMatrix()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double[] apply(int[] x$1) {
                        return (double[])Predef$.MODULE$.intArrayOps(x$1).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply(int x$2) {
                                return this.apply$mcDI$sp(x$2);
                            }

                            public double apply$mcDI$sp(int x$2) {
                                return x$2;
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))), false));
            }
        }, (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Array2DRowRealMatrix apply(Array2DRowRealMatrix x$3, Array2DRowRealMatrix x$4) {
                return x$3.add(x$4);
            }
        })).scalarMultiply(1.0 / (double)fas.size()).getData();
    }

    public <A> double sumOfSquaresSlow(FeatureAllocation<A> fa, double[][] pam) {
        return BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.refArrayOps((Object[])new Array2DRowRealMatrix((double[][])Predef$.MODULE$.refArrayOps((Object[])fa.pairwiseAllocationMatrix()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double[] apply(int[] x$5) {
                return (double[])Predef$.MODULE$.intArrayOps(x$5).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(int x$6) {
                        return this.apply$mcDI$sp(x$6);
                    }

                    public double apply$mcDI$sp(int x$6) {
                        return x$6;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)))), false).subtract(new Array2DRowRealMatrix(pam, false)).getDataRef()).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$7, double[] x$8) {
                return x$7 + BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(x$8).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double a, double b) {
                        return this.apply$mcDDD$sp(a, b);
                    }

                    public double apply$mcDDD$sp(double a, double b) {
                        return a + b * b;
                    }
                }));
            }
        }));
    }

    public <A> double sumOfAbsolutesSlow(FeatureAllocation<A> fa, double[][] pam) {
        return BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.refArrayOps((Object[])new Array2DRowRealMatrix((double[][])Predef$.MODULE$.refArrayOps((Object[])fa.pairwiseAllocationMatrix()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double[] apply(int[] x$9) {
                return (double[])Predef$.MODULE$.intArrayOps(x$9).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(int x$10) {
                        return this.apply$mcDI$sp(x$10);
                    }

                    public double apply$mcDI$sp(int x$10) {
                        return x$10;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))))).subtract(new Array2DRowRealMatrix(pam, false)).getDataRef()).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$11, double[] x$12) {
                return x$11 + BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(x$12).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double a, double b) {
                        return this.apply$mcDDD$sp(a, b);
                    }

                    public double apply$mcDDD$sp(double a, double b) {
                        return a + RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(b));
                    }
                }));
            }
        }));
    }

    private <A> double engine(int[][] counts, double[][] pam, Function1<Object, Object> f) {
        int nItems = pam.length;
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int i = 0; i < nItems; ++i) {
            int[] countsi = counts[i];
            double[] pami = pam[i];
            sum1 += f.apply$mcDD$sp((double)countsi[i] - pami[i]);
            for (int j = 0; j < i; ++j) {
                sum2 += f.apply$mcDD$sp((double)countsi[j] - pami[j]);
            }
        }
        return sum1 + (double)2 * sum2;
    }

    public <A> double sumOfSquares(FeatureAllocation<A> fa, double[][] pam) {
        return this.engine(fa.pairwiseAllocationTriangle(), pam, (Function1<Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return x * x;
            }
        });
    }

    public <A> double sumOfAbsolutes(FeatureAllocation<A> fa, double[][] pam) {
        return this.engine(fa.pairwiseAllocationTriangle(), pam, (Function1<Object, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(double x) {
                return this.apply$mcDD$sp(x);
            }

            public double apply$mcDD$sp(double x) {
                return RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(x));
            }
        });
    }

    public <A> FeatureAllocation<A> minAmongDraws(Seq<FeatureAllocation<A>> candidates, int maxSize, boolean multicore, String loss, Option<double[][]> pamOption) {
        if (candidates.isEmpty()) {
            throw new IllegalArgumentException("'candidates' cannot be empty.");
        }
        double[][] pam = (double[][])pamOption.getOrElse((Function0)new Serializable((Seq)candidates){
            public static final long serialVersionUID = 0L;
            private final Seq candidates$1;

            public final double[][] apply() {
                return FeatureAllocationSummary$.MODULE$.expectedPairwiseAllocationMatrix(this.candidates$1);
            }
            {
                this.candidates$1 = candidates$1;
            }
        });
        Function2<FeatureAllocation<A>, double[][], Object> lossEngine = this.getLoss(loss);
        Iterator iter = ((GenIterableLike)(multicore ? ParVector$.MODULE$.apply(candidates) : candidates)).iterator();
        return (FeatureAllocation)iter.minBy((Function1)new Serializable(maxSize, pam, lossEngine){
            public static final long serialVersionUID = 0L;
            private final int maxSize$1;
            private final double[][] pam$1;
            private final Function2 lossEngine$1;

            public final double apply(FeatureAllocation<A> featureAllocation) {
                return this.maxSize$1 > 0 && featureAllocation.size() > this.maxSize$1 ? Double.POSITIVE_INFINITY : BoxesRunTime.unboxToDouble((Object)this.lossEngine$1.apply(featureAllocation, (Object)this.pam$1));
            }
            {
                this.maxSize$1 = maxSize$1;
                this.pam$1 = pam$1;
                this.lossEngine$1 = lossEngine$1;
            }
        }, (Ordering)this.ordering());
    }

    public ListBuffer<FeatureAllocation<Null$>> org$ddahl$sdols$featureallocation$FeatureAllocationSummary$$expand(FeatureAllocation<Null$> fa, List<Feature<Null$>> availableFeatures, int i) {
        ListBuffer listBuffer;
        if (availableFeatures.isEmpty()) {
            listBuffer = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        } else {
            FeatureAllocation<Null$> faPlus = fa.add(i, (Feature)availableFeatures.head());
            List tail = (List)availableFeatures.tail();
            listBuffer = tail.isEmpty() ? (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new FeatureAllocation[]{fa, faPlus})) : (ListBuffer)this.org$ddahl$sdols$featureallocation$FeatureAllocationSummary$$expand(fa, (List<Feature<Null$>>)tail, i).$plus$plus(this.org$ddahl$sdols$featureallocation$FeatureAllocationSummary$$expand(faPlus, (List<Feature<Null$>>)tail, i));
        }
        return listBuffer;
    }

    public FeatureAllocation<Null$> org$ddahl$sdols$featureallocation$FeatureAllocationSummary$$padWithFeature(FeatureAllocation<Null$> fa, Feature<Null$> f, int nTimes) {
        FeatureAllocation<Null$> fa2 = fa;
        for (int j = 0; j < nTimes; ++j) {
            fa2 = fa2.add(f);
        }
        return fa2;
    }

    public FeatureAllocation<Null$> org$ddahl$sdols$featureallocation$FeatureAllocationSummary$$sequentiallyAllocatedLatentStructureOptimization(FeatureAllocation<Null$> initial, int maxSize, List<Object> permutation, double[][] pamTransform, Function2<FeatureAllocation<Null$>, double[][], Object> lossEngine) {
        int max = maxSize <= 0 ? Integer.MAX_VALUE : maxSize;
        ObjectRef fa = ObjectRef.create(initial);
        permutation.foreach((Function1)new Serializable(maxSize, pamTransform, lossEngine, max, fa){
            public static final long serialVersionUID = 0L;
            private final int maxSize$2;
            public final double[][] pamTransform$1;
            public final Function2 lossEngine$2;
            private final int max$1;
            private final ObjectRef fa$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                FeatureAllocation featureAllocation;
                Feature<Object> singleton = Feature$.MODULE$.apply(null, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{i}));
                int expectedNumberOfFeatures = (int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(this.pamTransform$1[i][i]));
                if (((FeatureAllocation)this.fa$1.elem).isEmpty()) {
                    featureAllocation = FeatureAllocationSummary$.MODULE$.org$ddahl$sdols$featureallocation$FeatureAllocationSummary$$padWithFeature((FeatureAllocation)this.fa$1.elem, singleton, RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(expectedNumberOfFeatures), this.max$1));
                } else {
                    ListBuffer candidates = FeatureAllocationSummary$.MODULE$.org$ddahl$sdols$featureallocation$FeatureAllocationSummary$$expand((FeatureAllocation)this.fa$1.elem, ((FeatureAllocation)this.fa$1.elem).toList(), i);
                    int residualCapacity = this.maxSize$2 - ((FeatureAllocation)this.fa$1.elem).nFeatures();
                    ListBuffer candidates2 = residualCapacity > 0 ? (ListBuffer)candidates.map((Function1)new Serializable(this, singleton, expectedNumberOfFeatures, residualCapacity, i){
                        public static final long serialVersionUID = 0L;
                        private final Feature singleton$1;
                        private final int expectedNumberOfFeatures$1;
                        private final int residualCapacity$1;
                        private final int i$1;

                        public final FeatureAllocation<Null$> apply(FeatureAllocation<Null$> fa2) {
                            return FeatureAllocationSummary$.MODULE$.org$ddahl$sdols$featureallocation$FeatureAllocationSummary$$padWithFeature(fa2, this.singleton$1, RichInt$.MODULE$.min$extension(Predef$.MODULE$.intWrapper(this.expectedNumberOfFeatures$1 - fa2.nFeatures(this.i$1)), this.residualCapacity$1));
                        }
                        {
                            this.singleton$1 = singleton$1;
                            this.expectedNumberOfFeatures$1 = expectedNumberOfFeatures$1;
                            this.residualCapacity$1 = residualCapacity$1;
                            this.i$1 = i$1;
                        }
                    }, ListBuffer$.MODULE$.canBuildFrom()) : candidates;
                    featureAllocation = (FeatureAllocation)candidates2.minBy((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun$org$ddahl$sdols$featureallocation$FeatureAllocationSummary$$sequentiallyAllocatedLatentStructureOptimization$1 $outer;

                        public final double apply(FeatureAllocation<Null$> x$13) {
                            return BoxesRunTime.unboxToDouble((Object)this.$outer.lossEngine$2.apply(x$13, (Object)this.$outer.pamTransform$1));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, (Ordering)FeatureAllocationSummary$.MODULE$.ordering());
                }
                this.fa$1.elem = featureAllocation;
            }
            {
                this.maxSize$2 = maxSize$2;
                this.pamTransform$1 = pamTransform$1;
                this.lossEngine$2 = lossEngine$2;
                this.max$1 = max$1;
                this.fa$1 = fa$1;
            }
        });
        return (FeatureAllocation)fa.elem;
    }

    private <A> Function2<FeatureAllocation<A>, double[][], Object> getLoss(String loss) {
        String string;
        block4: {
            Object object;
            block3: {
                block2: {
                    string = loss;
                    if (!"squaredError".equals(string)) break block2;
                    object = new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final double apply(FeatureAllocation<A> fa, double[][] pam) {
                            return FeatureAllocationSummary$.MODULE$.sumOfSquares(fa, pam);
                        }
                    };
                    break block3;
                }
                if (!"absoluteError".equals(string)) break block4;
                object = new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final double apply(FeatureAllocation<A> fa, double[][] pam) {
                        return FeatureAllocationSummary$.MODULE$.sumOfAbsolutes(fa, pam);
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)string);
    }

    public Tuple3<FeatureAllocation<Null$>, Object, Object> sequentiallyAllocatedLatentStructureOptimization(int nCandidates, double budgetInSeconds, double[][] pam, int maxSize, int maxScans, boolean multicore, String loss) {
        Function2 lossEngine = this.getLoss(loss);
        Random rng = new Random();
        int nItems = pam.length;
        List ints = (List)List$.MODULE$.tabulate(nItems, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int x) {
                return this.apply$mcII$sp(x);
            }

            public int apply$mcII$sp(int x) {
                return BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToInteger((int)x)));
            }
        });
        FeatureAllocation empty = FeatureAllocation$.MODULE$.empty(nItems);
        int nCores = multicore ? Runtime.getRuntime().availableProcessors() : 1;
        int nCandidatesPerThread = (nCandidates - 1) / nCores + 1;
        double budgetInMillis = budgetInSeconds <= 0.0 ? 9.223372036854776E18 : budgetInSeconds * (double)1000L;
        long start = System.currentTimeMillis();
        List futures = (List)List$.MODULE$.fill(nCores, (Function0)new Serializable(pam, maxSize, lossEngine, rng, ints, empty, nCandidatesPerThread, budgetInMillis, start){
            public static final long serialVersionUID = 0L;
            public final double[][] pam$2;
            public final int maxSize$3;
            public final Function2 lossEngine$3;
            public final Random rng$1;
            public final List ints$1;
            public final FeatureAllocation empty$1;
            public final int nCandidatesPerThread$1;
            public final double budgetInMillis$1;
            public final long start$1;

            public final Future<Tuple4<FeatureAllocation<Null$>, Object, Object, Object>> apply() {
                return Future$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.4 $outer;

                    public final Tuple4<FeatureAllocation<Null$>, Object, Object, Object> apply() {
                        int counter;
                        double minScore = Double.POSITIVE_INFINITY;
                        Tuple2 best = new Tuple2(null, (Object)BoxesRunTime.boxToInteger((int)-1));
                        for (counter = 0; counter < this.$outer.nCandidatesPerThread$1 && (double)(System.currentTimeMillis() - this.$outer.start$1) <= this.$outer.budgetInMillis$1; ++counter) {
                            List permutation = (List)this.$outer.rng$1.shuffle((TraversableOnce)this.$outer.ints$1, List$.MODULE$.canBuildFrom());
                            Tuple2 candidate = new Tuple2(FeatureAllocationSummary$.MODULE$.org$ddahl$sdols$featureallocation$FeatureAllocationSummary$$sequentiallyAllocatedLatentStructureOptimization(this.$outer.empty$1, this.$outer.maxSize$3, (List<Object>)permutation, this.$outer.pam$2, (Function2<FeatureAllocation<Null$>, double[][], Object>)this.$outer.lossEngine$3), (Object)BoxesRunTime.boxToInteger((int)-1));
                            double score = BoxesRunTime.unboxToDouble((Object)this.$outer.lossEngine$3.apply(candidate._1(), (Object)this.$outer.pam$2));
                            if (!(score < minScore)) continue;
                            minScore = score;
                            best = candidate;
                        }
                        return new Tuple4(best._1(), (Object)BoxesRunTime.boxToInteger((int)best._2$mcI$sp()), (Object)BoxesRunTime.boxToDouble((double)minScore), (Object)BoxesRunTime.boxToInteger((int)counter));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
            }
            {
                this.pam$2 = pam$2;
                this.maxSize$3 = maxSize$3;
                this.lossEngine$3 = lossEngine$3;
                this.rng$1 = rng$1;
                this.ints$1 = ints$1;
                this.empty$1 = empty$1;
                this.nCandidatesPerThread$1 = nCandidatesPerThread$1;
                this.budgetInMillis$1 = budgetInMillis$1;
                this.start$1 = start$1;
            }
        });
        List seq = (List)Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((TraversableOnce)futures, List$.MODULE$.canBuildFrom(), (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global()), (Duration)Duration$.MODULE$.Inf());
        int nCandidatesInPractice = BoxesRunTime.unboxToInt((Object)seq.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(int sum, Tuple4<FeatureAllocation<Null$>, Object, Object, Object> tuple) {
                return sum + BoxesRunTime.unboxToInt((Object)tuple._4());
            }
        }));
        Tuple4 best = (Tuple4)seq.minBy((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple4<FeatureAllocation<Null$>, Object, Object, Object> x$14) {
                return BoxesRunTime.unboxToDouble((Object)x$14._3());
            }
        }, (Ordering)this.ordering());
        return new Tuple3(best._1(), best._2(), (Object)BoxesRunTime.boxToInteger((int)nCandidatesInPractice));
    }

    private FeatureAllocationSummary$() {
        MODULE$ = this;
        this.ordering = CrossCompatibility$.MODULE$.doubleOrdering();
    }
}

