\name{pa}
\alias{pa}
\alias{pa,SpatRaster,sdmModels-method}
\alias{pa,SpatRaster,numeric-method}

\title{Converting probability of occurrence to Presence-absence}


\description{
For many applications, the predicted probability of occurrence (habitat suitability) should be transformed to presence-absence given a threshold which can be selected based on some criteria through model evaluation. \code{pa} facilitates this transformation based on either the threshold specified by a user or extracted from the models (or ensemble of the mdoels).
}

\usage{
pa(x,y,id,opt,...)
}

\arguments{
  \item{x}{a SpatRaster object contains predicted probability of occurrence generated by the predict or ensemble functions}
  \item{y}{eithe a sdmModels (outcome of the sdm function) or a numeric vector with threshold values}
  \item{id}{when \code{y} is sdmModels, \code{id} can be either a numeric vector specifying the modelIDs corresponding to the layers in \code{x}, or a single character "ensemble" to tell the function that the single layer in \code{x} is generated from the ensemble function, so the threshold should also be obtained based on ensemble}
  \item{opt}{when \code{y} is sdmModels, \code{opt} specifies the optimisation criterion based on which a threshold is identified; default is opt=2 (see \code{\link{evaluates}} for more details) }
  \item{...}{not implemented.}
  }

\details{
if \code{id} is numeric, the number of layers in \code{x} (SpatRaster) should be the same as the length of \code{id}, but if \code{id = "ensemble"}, \code{nlyr(x)} should be 1.

}

\value{
a SpatRaster with presence-absence values
}


\references{
Naimi, B., Araujo, M.B. (2016) sdm: a reproducible and extensible R platform for species distribution modelling, Ecography, 39:368-375, DOI: 10.1111/ecog.01881


}

\author{Babak Naimi \email{naimi.b@gmail.com}

\url{https://www.r-gis.net/}

\url{https://www.biogeoinformatics.org/}
}





\examples{
\dontrun{

# let's first fit a set of models and generate prediction and ensemble maps:

# get the path to the species data
file <- system.file("external/sp1.shp", package="sdm") 

sp <- vect(file) # read the species records

path <- system.file("external", package="sdm") # path to the folder contains the data

lst <- list.files(path=path,pattern='asc$',full.names = T) # list of predictor filenames

preds <- rast(lst) # making a SpatRaster object (predictors)

d <- sdmData(formula=Occurrence~., train=sp, predictors=preds)

d

# fit two models:
m <- sdm(Occurrence~.,data=d,methods=c('glmp','brt'),replication='boot',n=1)

m 

# predictions:  
pr <- predict(m, newdata=preds)

plot(pr)


# ensemble::    
en <- ensemble(m, newdata=preds,setting=list(method='weighted',stat='AUC'))

plot(en)

#########################
# let's convert probabilities to Presence/absences:


# threshold is extracted for both models based on opt=2 (max[se+sp])
pr.pa <- pa(pr, m, opt=2) 

plot(pr.pa)

# if only one of them was needed:

pr.pa1 <- pa(pr[[1]],m, id=1,opt=2)

plot(pr.pa1)
#---------------
# if you have threshold values, you can directly use them in y:

th <- getEvaluation(m,stat='threshold',opt=1) # get threshold values 

th

pr.pa <- pa(pr, y=th[,2])

plot(pr.pa)
#--------------
# to convert to PA based on "ensemble":

en.pa <- pa(en, m, id="ensemble", opt=2)

plot(en.pa)


}
}

\keyword{spatial}
\keyword{species}
\keyword{data}
