% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pde.R
\name{dTpdPde1D}
\alias{dTpdPde1D}
\title{Transition probability density in 1D by PDE solving}
\usage{
dTpdPde1D(Mx = 500, x0, t, alpha, mu, sigma, type = "WN",
  Mt = ceiling(100 * t), sdInitial = 0.1, ...)
}
\arguments{
\item{Mx}{size of the equispaced spatial grid in \eqn{[-\pi,\pi)}.}

\item{x0}{point giving the mean of the initial circular density, a WN with
standard deviation equal to \code{sdInitial}.}

\item{t}{time separating \code{x0} and the evaluation of the tpd.}

\item{alpha}{drift parameter.}

\item{mu}{mean parameter. Must be in \eqn{[\pi,\pi)}.}

\item{sigma}{diffusion coefficient.}

\item{type}{either \code{"WN"} or \code{"vM"}.}

\item{Mt}{size of the time grid in \eqn{[0, t]}.}

\item{sdInitial}{the standard deviation of the concentrated WN giving the
initial condition.}

\item{...}{Further parameters passed to \code{\link{crankNicolson1D}}.}
}
\value{
A vector of length \code{Mx} with the tpd evaluated at
\code{seq(-pi, pi, l = Mx + 1)[-(Mx + 1)]}.
}
\description{
Computation of the transition probability density (tpd) of the
Wrapped Normal (WN) or von Mises (vM) diffusion, by solving its associated
Fokker--Planck Partial Differential Equation (PDE) in 1D.
}
\details{
A combination of small \code{sdInitial} and coarse space-time
discretization (small \code{Mx} and \code{Mt}) is prone to create numerical
instabilities. See Sections 3.4.1, 2.2.1 and 2.2.2 in García-Portugués et
al. (2019) for details.
}
\examples{
Mx <- 100
x <- seq(-pi, pi, l = Mx + 1)[-c(Mx + 1)]
x0 <- pi
t <- 0.5
alpha <- 1
mu <- 0
sigma <- 1
isRStudio <- identical(.Platform$GUI, "RStudio")
if (isRStudio) {
  manipulate::manipulate({
  plot(x, dTpdPde1D(Mx = Mx, x0 = x0, t = t, alpha = alpha, mu = 0,
                    sigma = sigma), type = "l", ylab = "Density",
       xlab = "", ylim = c(0, 0.75))
  lines(x, dTpdWou1D(x = x, x0 = rep(x0, Mx), t = t, alpha = alpha, mu = 0,
                      sigma = sigma), col = 2)
  }, x0 = manipulate::slider(-pi, pi, step = 0.01, initial = 0),
  alpha = manipulate::slider(0.01, 5, step = 0.01, initial = 1),
  sigma = manipulate::slider(0.01, 5, step = 0.01, initial = 1),
  t = manipulate::slider(0.01, 5, step = 0.01, initial = 1))
}
}
\references{
García-Portugués, E., Sørensen, M., Mardia, K. V. and Hamelryck, T. (2019)
Langevin diffusions on the torus: estimation and applications.
\emph{Statistics and Computing}, 29(2):1--22. \doi{10.1007/s11222-017-9790-2}
}
