% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OU.R
\name{alphaToA}
\alias{alphaToA}
\alias{aToAlpha}
\title{Valid drift matrices for the Ornstein--Uhlenbeck diffusion in 2D}
\usage{
alphaToA(alpha, sigma = NULL, rho = 0, Sigma = NULL)

aToAlpha(A, sigma = NULL, rho = 0, Sigma = NULL)
}
\arguments{
\item{alpha}{vector of length \code{3} containing the \code{A} matrix. The first two elements are the diagonal.}

\item{sigma}{vector of length \code{2} containing the \strong{square root} of the diagonal of \code{Sigma}.}

\item{rho}{correlation of \code{Sigma}.}

\item{Sigma}{the diffusion matrix of size \code{c(2, 2)}.}

\item{A}{matrix of size \code{c(2, 2)}.}
}
\value{
The drift matrix \code{A} or the \code{alpha} vector.
}
\description{
Constructs drift matrices \eqn{A} such that \code{solve(A) \%*\% Sigma} is symmetric.
}
\details{
The parametrization enforces that \code{solve(A) \%*\% Sigma} is symmetric. Positive definiteness is guaranteed if \code{alpha[3]^2 < rho^2 * (alpha[1] - alpha[2])^2 / 4 + alpha[1] * alpha[2]}.
}
\examples{
# Parameters
alpha <- 3:1
Sigma <- rbind(c(1, 0.5), c(0.5, 4))

# Covariance matrix
A <- alphaToA(alpha = alpha, Sigma = Sigma)
S <- 0.5 * solve(A) \%*\% Sigma
det(S)

# Check
aToAlpha(A = alphaToA(alpha = alpha, Sigma = Sigma), Sigma = Sigma)
alphaToA(alpha = aToAlpha(A = A, Sigma = Sigma), Sigma = Sigma)
}
