% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OU.R
\name{rTrajMou}
\alias{rTrajMou}
\title{Simulation of trajectories for the multivariate OU diffusion}
\usage{
rTrajMou(x0, A, mu, Sigma, N = 100, delta = 0.001)
}
\arguments{
\item{x0}{a vector of length \code{p} containing initial point.}

\item{A}{the drift matrix, of size \code{c(p, p)}.}

\item{mu}{unconditional mean of the diffusion, a vector of length \code{p}.}

\item{Sigma}{square of the diffusion matrix, a matrix of size \code{c(p, p)}.}

\item{N}{number of discretization steps in the resulting trajectory.}

\item{delta}{time discretization step.}
}
\value{
A matrix of size \code{c(N + 1, p)} containing \code{x0} in the first row and  the exact discretized trajectory on the remaining rows.
}
\description{
Simulation of trajectories of the \emph{multivariate} Ornstein--Uhlenbeck (OU) diffusion
\deqn{dX_t=A(\mu - X_t)dt+\Sigma^\frac{1}{2}dW_t, X_0=x_0}{dX_t=A(mu - X_t)dt+Sigma^(1/2) dW_t, X0=x0} using the exact transition probability density.
}
\details{
The law of the discretized trajectory at \emph{each} time step is a multivariate normal with mean \code{\link{meantMou}} and covariance matrix \code{\link{covtMou}}. See \code{\link{rTrajOu}} for the univariate case (more efficient).

\code{solve(A) \%*\% Sigma} has to be a covariance matrix (symmetric and positive definite) in order to have a proper transition density. For the bivariate case, this can be ensured with the \code{\link{alphaToA}} function. In the multivariate case, it is ensured if \code{Sigma} is isotropic and \code{A} is a covariance matrix.
}
\examples{
set.seed(987658)
data <- rTrajMou(x0 = c(0, 0), A = alphaToA(alpha = c(1, 2, 0.5),
                 sigma = 1:2), mu = c(1, 1), Sigma = diag((1:2)^2),
                 N = 200, delta = 0.1)
plot(data, pch = 19, col = rainbow(201), cex = 0.25)
arrows(x0 = data[-201, 1], y0 = data[-201, 2], x1 = data[-1, 1],
       y1 = data[-1, 2], col = rainbow(201), angle = 10, length = 0.1)
}
