% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{euler1D}
\alias{euler1D}
\title{Simulation of trajectories of the WN or vM diffusion in 1D}
\usage{
euler1D(x0, alpha, mu, sigma, N = 100L, delta = 0.01, type = 1L,
  maxK = 2L, expTrc = 30)
}
\arguments{
\item{x0}{vector of length \code{nx0} giving the initial points.}

\item{alpha}{drift parameter.}

\item{mu}{mean parameter. Must be in \eqn{[\pi,\pi)}.}

\item{sigma}{diffusion coefficient.}

\item{N}{number of discretization steps.}

\item{delta}{discretization step.}

\item{type}{integer giving the type of diffusion. Currently, only \code{1} for WN and \code{2} for vM are supported.}

\item{maxK}{maximum absolute value of the windings considered in the computation of the WN.}

\item{expTrc}{truncation for exponential: \code{exp(x)} with \code{x <= -expTrc} is set to zero. Defaults to \code{30}.}
}
\value{
A matrix of size \code{c(nx0, N + 1)} containing the \code{nx0} discretized trajectories. The first column corresponds to the vector \code{x0}.
}
\description{
Simulation of the Wrapped Normal (WN) diffusion or von Mises (vM) diffusion by the Euler method in 1D, for several starting values.
}
\examples{
N <- 100
nx0 <- 20
x0 <- seq(-pi, pi, l = nx0 + 1)[-(nx0 + 1)]
set.seed(12345678)
samp <- euler1D(x0 = x0, mu = 0, alpha = 3, sigma = 1, N = N,
                delta = 0.01, type = 2)
tt <- seq(0, 1, l = N + 1)
plot(rep(0, nx0), x0, pch = 16, col = rainbow(nx0), xlim = c(0, 1))
for (i in 1:nx0) linesCirc(tt, samp[i, ], col = rainbow(nx0)[i])
}
