% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{class}
\name{sdcTargetDefinitionClass-class}
\alias{initialize,sdcTargetDefinitionClass-method}
\alias{sdcTargetDefinitionClass-class}
\title{S4 Target Definition}
\usage{
\S4method{initialize}{sdcTargetDefinitionClass}(.Object, ...)
}
\arguments{
\item{.Object}{An \code{\linkS4class{sdcTargetDefinitionClass}} object.}

\item{...}{The optional parameters specifying the data
  and other options.
  Among these are
\tabular{ll}{
Name   \tab Description                                         \cr
X      \tab A data frame with the data, not necessarily         \cr
       \tab standardised.                                       \cr
Hdef   \tab A hashing definition, if generated externally,      \cr
       \tab perhaps because it comes from a larger set of data. \cr
cutoff \tab The minimum residual cell size.                     \cr
}}
}
\description{
The SDC target definition is used to calculate a target matrix.
}
\details{
The hashing definition presently handles only categorical
  fields, which limits the applicability of this software
  accordingly.
}
\section{Methods (by generic)}{
\itemize{
\item \code{initialize}: 
}}
\section{Slots}{

\describe{
\item{\code{dim}}{The dimensions of the data on which the target definition
is calculated.}

\item{\code{dimnames}}{A list of row and column names of the data on which the
target definition is calculated, in the form returned
by \code{\link[base]{dim}}.}

\item{\code{cutoff}}{The minimum residual cell size.}

\item{\code{rownames}}{The row names of the target elements.}

\item{\code{size}}{The size of each target element.}

\item{\code{index}}{The index of each target element.}

\item{\code{hash}}{The target hash vector.}
}}
\examples{
new("sdcTargetDefinitionClass")
set.seed(256)
my.X <- data.frame(matrix(ifelse(runif(500)>.5, TRUE, FALSE), ncol = 5))
new("sdcTargetDefinitionClass", X = my.X)
}
\seealso{
\code{\linkS4class{sdcTargetMatrixClass}},
}

