% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy-funs.R
\name{taxonomy}
\alias{tax_no_epithet}
\alias{taxonomy}
\title{Taxonomy based cleaning}
\usage{
tax_no_epithet(x, name = NULL, drop = TRUE)
}
\arguments{
\item{x}{(data.frame) A data.frame}

\item{name}{(character) Taxonomic name field Optional. See Details.}

\item{drop}{(logical) Drop bad data points or not. Either way, we parse
out bade data points as an attribute you can access. Default: \code{TRUE}}
}
\value{
Returns a data.frame, with attributes
}
\description{
Taxonomy based cleaning
}
\examples{
if (requireNamespace("rgbif", quietly = TRUE)) {
   library("rgbif")
   res <- rgbif::occ_data(limit = 200)$data
} else {
   res <- sample_data_3
}

# Remove records where names don't have genus + epithet
## so removes those with only genus and those with no name (NA or NULL)
NROW(res)
df <- dframe(res) \%>\% tax_no_epithet(name = "name")
NROW(df)
attr(df, "name_var")
attr(df, "tax_no_epithet")
}

