% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{coop_lasso}
\alias{coop_lasso}
\title{ADMM algorithm for solving the group-penalized least squares problem}
\usage{
coop_lasso(
  y,
  x,
  lambda,
  weights,
  beta_0 = NULL,
  rho_0 = 0.2,
  alpha_0 = 1.5,
  n_update = 2L,
  eps_corr = 0.2,
  max_iter = 1000L,
  eps_rel = 1e-08,
  eps_abs = 1e-12,
  verbose = FALSE
)
}
\arguments{
\item{y}{Target (n x m)}

\item{x}{Design matrix (n x p)}

\item{lambda}{Penalization parameter}

\item{weights}{A specific weight for each group (typically this is
\verb{sqrt(group size)}).}

\item{beta_0}{Initial value for coefficients, allowing for warm start.
Can be set to NULL, which results in the initial \code{beta}
being a zero matrix.}

\item{rho_0}{Initial ADMM step-size}

\item{alpha_0}{Initial ADMM relaxation parameter}

\item{n_update}{Number of steps in-between updates of the
step-size/adaptation parameters}

\item{eps_corr}{Lower bound for the correlation in the step-size
update steps}

\item{max_iter}{Maximum number of iterations}

\item{eps_rel}{Relative tolerance for convergence check}

\item{eps_abs}{Absolute tolerance for convergence check}

\item{verbose}{Whether or not information about the optimization process
should be printed to the terminal}
}
\value{
A list containing
\item{beta}{The coefficients at convergence}
\item{iterations}{Number of iterations}
}
\description{
Implements estimation of the coop-lasso problem.
}
\references{
Xu et al. (2017) Adaptive relaxed ADMM: Convergence theory and
practical implementation. DOI 10.1109/CVPR.2017.765
}
\keyword{internal}
