% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{random_forest_parameters}
\alias{random_forest_parameters}
\title{Hyperparameter optimisation or parameter tuning for Random Forest by grid search}
\usage{
random_forest_parameters(base, target, model_type, ntree, mtry,
  maxnodes = NULL, nodesize, error = "rmse", cv = 1)
}
\arguments{
\item{base}{input dataframe}

\item{target}{column / field name for the target variable to be passed as string (must be 0/1 type)}

\item{model_type}{to be chosen among "regression" or "classification"}

\item{ntree}{number of trees to be fitted}

\item{mtry}{number of variable to be sampled as split criteria at each node}

\item{maxnodes}{(optional) Maximum number of terminal nodes (default is NULL ie. no restriction on depth of the trees)}

\item{nodesize}{minimum size of terminal nodes}

\item{error}{(optional) error measure as objective function to be minimised, to be chosen among "mae", "mse" and "rmse" (default value is "rmse")}

\item{cv}{(optional) k vakue for k-fold cross validation to be performed (default value is 1 ie. without cross validation)}
}
\value{
An object of class "random_forest_parameters" is a list containing the following components:

\item{error_tab_detailed}{error summary for each cross validation sample of the parameter combinations iterated during grid search as a dataframe}

\item{error_tab_summary}{error summary for each combination of parameters as a dataframe}

\item{best_ntree}{ntree parameter of the optimal solution}

\item{best_mtry}{mtry parameter of the optimal solution}

\item{maxnodes}{maxnodes parameter of the optimal solution}

\item{best_nodesize}{nodesize parameter of the optimal solution}

\item{runtime}{runtime of the entire process}
}
\description{
The function runs a grid search with k-fold cross validation to arrive at best parameter decided by some performance measure. The parameters that can be tuned using this function for random forest algorithm are - ntree, mtry, maxnodes and nodesize. The objective function to be minimised is the error (mean absolute error / mean squared error / root mean squared error). For the grid search, the possible values of each tuning parameter needs to be passed as an array into the function.
}
\examples{
data <- iris
set.seed(11)
data$Y <- sample(0:1,size=nrow(data),replace=TRUE)
rf_params_list <- random_forest_parameters(base = data,target = "Y",
                  model_type = "classification",ntree = 2,mtry = 1,nodesize = 3)
rf_params_list$error_tab_detailed
rf_params_list$error_tab_summary
rf_params_list$best_ntree
rf_params_list$best_mtry
rf_params_list$maxnodes
rf_params_list$best_nodesize
rf_params_list$runtime
}
\author{
Arya Poddar <aryapoddar290990@gmail.com>

Aiana Goyal <aianagoel002@gmail.com>
}
