% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{fn_conf_mat}
\alias{fn_conf_mat}
\title{Creates confusion matrix and its related measures}
\usage{
fn_conf_mat(base, observed_col, predicted_col, event)
}
\arguments{
\item{base}{input dataframe}

\item{observed_col}{column / field name of the observed event}

\item{predicted_col}{column / field name of the predicted event}

\item{event}{the event class, to be passed as string}
}
\value{
An object of class "fn_conf_mat" is a list containing the following components:

\item{confusion_mat}{confusion matrix as a table}

\item{accuracy}{accuracy measure}

\item{precision}{precision measure}

\item{recall}{recall measure}

\item{sensitivity}{sensitivity measure}

\item{specificity}{specificity measure}

\item{f1_score}{F1 score}
}
\description{
The function takes the base dataframe with observed/actual and predicted columns. The actual/predicted class preferably should be binary and if not, it will be considered as event vs rest. It computes the performance measures like accuracy, precision, recall, sensitivity, specificity and f1 score.
}
\examples{
data <- iris
data$Species <- as.character(data$Species)
set.seed(11)
data$Y <- sample(0:1,size=nrow(data),replace=TRUE)
data$Y_pred <- sample(0:1,size=nrow(data),replace=TRUE)
fn_conf_mat_list <- fn_conf_mat(base = data,observed_col = "Y",predicted_col = "Y_pred",event = 1)
fn_conf_mat_list$confusion_mat
fn_conf_mat_list$accuracy
fn_conf_mat_list$precision
fn_conf_mat_list$recall
fn_conf_mat_list$sensitivity
fn_conf_mat_list$specificity
fn_conf_mat_list$f1_score
}
\author{
Arya Poddar <aryapoddar290990@gmail.com>
}
