% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{categorical_iv}
\alias{categorical_iv}
\title{IV table for individual categorical variable}
\usage{
categorical_iv(base, target, variable, event = 1)
}
\arguments{
\item{base}{input dataframe}

\item{target}{column / field name for the target variable to be passed as string (must be 0/1 type)}

\item{variable}{categorical variable name for which IV is to be calculated, to be passed as string}

\item{event}{(optional) the event class, to be passed as 0 or 1 (default is 1)}
}
\value{
The function returns a dataframe.
}
\description{
The function takes base data, target and the categorical variable for which IV is to be calculated. It returns a dataframe with the WOE and IV value of the variable.
}
\examples{
data <- iris
data$Species <- as.character(data$Species)
data$Y <- sample(0:1,size=nrow(data),replace=TRUE)
cat_iv <- categorical_iv(base = data,target = "Y",variable = "Species",event = 1)
}
\author{
Arya Poddar <aryapoddar290990@gmail.com>

Aiana Goyal <aianagoel002@gmail.com>
}
