% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/woebin.R
\name{woebin_adj}
\alias{woebin_adj}
\title{WOE Binning Adjustment}
\usage{
woebin_adj(dt, y, bins, adj_all_var = TRUE, special_values = NULL,
  method = "tree", save_breaks_list = NULL, count_distr_limit = 0.05,
  ...)
}
\arguments{
\item{dt}{A data frame.}

\item{y}{Name of y variable.}

\item{bins}{A list of data frames. Binning information generated from \code{woebin}.}

\item{adj_all_var}{Logical, whether to show variables have monotonic woe trends. Default is TRUE}

\item{special_values}{The values specified in special_values will in separate bins. Default is NULL.}

\item{method}{Optimal binning method, it should be "tree" or "chimerge". Default is "tree".}

\item{save_breaks_list}{A string. The file name to save breaks_list. Default is None.}

\item{count_distr_limit}{The minimum count distribution percentage. Accepted range: 0.01-0.2; default is 0.05. This argument should be the same with woebin's.}

\item{...}{Additional parameters.}
}
\value{
A list of modified break points of each x variables.
}
\description{
\code{woebin_adj} interactively adjust the binning breaks.
}
\examples{
\dontrun{
# Load German credit data
data(germancredit)

# Example I
dt = germancredit[, c("creditability", "age.in.years", "credit.amount")]
bins = woebin(dt, y="creditability")
breaks_adj = woebin_adj(dt, y="creditability", bins)
bins_final = woebin(dt, y="creditability",
                    breaks_list=breaks_adj)

# Example II
binsII = woebin(germancredit, y="creditability")
breaks_adjII = woebin_adj(germancredit, "creditability", binsII)
bins_finalII = woebin(germancredit, y="creditability",
                    breaks_list=breaks_adjII)
}

}
\seealso{
\code{\link{woebin}}, \code{\link{woebin_ply}}, \code{\link{woebin_plot}}
}
