% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splitdf.R
\name{split_df}
\alias{split_df}
\title{Split a dataset}
\usage{
split_df(dt, y = NULL, ratio = 0.7, seed = 186)
}
\arguments{
\item{dt}{A data frame.}

\item{y}{Name of y variable, defaults NULL. The dataset dt will split based on the predictor y, if it is specified.}

\item{ratio}{A numeric value, defaults 0.7. It indicates the ratio of total rows contained in one split, must less than 1.}

\item{seed}{A random seed, defaults 186. The specify seed is used for random sorting data.}
}
\description{
Split a dataset
}
\examples{
library(scorecard)
data(germancredit)

dts <- split_df(germancredit, y="creditability")
train <- dts$train
test <- dts$test

}
