% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.R
\name{quadeTest}
\alias{quadeTest}
\title{Quade's test}
\usage{
quadeTest(data, ...)
}
\arguments{
\item{data}{Matrix where the test is performed}

\item{...}{Ignored}
}
\value{
A list with class "htest" containing the following components: \code{statistic}, the value of the statistic used in the test; \code{parameter}, the two degrees of freedom of the F distribution; \code{p.value}, the p-value for the test; \code{method}, a character string indicating what type of test was performed and \code{data.name}, a character string giving the name of the data.
}
\description{
This function performs Quade's test for multiple comparisons
}
\details{
The test has been implemented according to the version in Garcia \emph{et al.} (2008).
}
\examples{
data(data_gh_2008)
quadeTest(data.gh.2008)

}
\references{
S. Garcia, A. Fernandez, J. Luengo and F. Herrera (2010) Advanced nonparametric tests for multiple comparisons in the design of experiments in computational intelligence and ata mining: Experimental analysis of power. \emph{Information Sciences}, 180, 2044-2064.
}

