% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEO.R
\name{ExtractGEOExpSuppAll}
\alias{ExtractGEOExpSuppAll}
\title{Extract Raw Count Matrix from Supplementary Files or Fortmat Supplementary Files to 10x.}
\usage{
ExtractGEOExpSuppAll(
  acce,
  supp.idx = 1,
  timeout = 3600,
  supp.type = c("count", "10x"),
  out.folder = NULL,
  gene2feature = TRUE
)
}
\arguments{
\item{acce}{GEO accession number.}

\item{supp.idx}{The index of supplementary files to download. Default: 1.}

\item{timeout}{Timeout for \code{\link{download.file}}. Default: 3600.}

\item{supp.type}{The type of downloaded supplementary files, choose from count (count matrix file or single count matrix file)
and 10x (cellranger output files, contains barcodes, genes/features and matrix). Default: count.}

\item{out.folder}{Output folder to save 10x files. Default: NULL (current working directory).}

\item{gene2feature}{Logical value, whether to rename \code{genes.tsv.gz} to \code{features.tsv.gz}. Default: TRUE.
Default: TURE.}
}
\value{
Count matrix (\code{supp.type} is count) or NULL (\code{supp.type} is 10x).
}
\description{
Extract Raw Count Matrix from Supplementary Files or Fortmat Supplementary Files to 10x.
}
