% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dgCMatToJMat}
\alias{dgCMatToJMat}
\title{dgCMatToJMat}
\usage{
dgCMatToJMat(
  q,
  fname,
  mtype = "sparse",
  ctype = "raw",
  valuetype = "float",
  transpose = FALSE,
  comment = ""
)
}
\arguments{
\item{q}{The dgCMatrix object}

\item{fname}{A string with the name of the binary output file}

\item{mtype}{A string to indicate the matrix type: 'full' or 'sparse'. Default: 'sparse'}

\item{ctype}{The string 'raw' or 'log1' to write raw counts or log(counts+1), or the normalized versions, 'rawn' and 'log1n', which normalize ALWAYS BY COLUMNS (before transposition, if requested to transpose). Default: raw}

\item{valuetype}{The data type to store the matrix. It must be one of the strings 'uint32', 'float' or 'double'. Default: float}

\item{transpose}{Boolean to indicate if the matrix should be transposed before writing. See Details for a comment about this. Default: FALSE}

\item{comment}{A comment to be stored with the matrix. Default: "" (no comment)}
}
\value{
No return value, called for side effects (creates a file)
}
\description{
Gets a dgCMatrix object and writes to a disk file the binary matrix of counts contained in it in the jmatrix binary format. Plase, see Details
below to know more about the extraction of the sparse matrices from Seurat or similar single cell formats.
}
\details{
We have found that, in some Seurat objects, the dgCMatrix to be passed to this function can be extracted as q@assays$RNA@counts, being q the Seurat S4 object.\cr
In other cases this matrix is obtained as q@raw.data.\cr
In any case, we assume that this matrix has slots Dimnames (with a list of strings in Dimnames[[0]] as rownames and Dimnames[[1]]
as column names) as long as slots with names i, p and x as described in the documentation of the R Matrix library on sparse matrices.

The parameter transpose has the default value of FALSE. But don't forget to set it to TRUE if you want the cells
(which in single cell common practice are by columns) to be written by rows. This will be needed later to calculate
the dissimilarity matrix, if this is the next step of your workflow. See help of CalcAndWriteDissimilarityMatrix
}
\examples{
# Sorry, we cannot provide an example here, since it would need the load of the Seurat package.
# Please, see the vignette for examples
}
