% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{FilterBySilhouetteThreshold}
\alias{FilterBySilhouetteThreshold}
\title{FilterBySilhouetteThreshold}
\usage{
FilterBySilhouetteThreshold(
  s,
  L,
  fallcounts,
  ffilcounts,
  falldissim,
  ffildissim,
  thres = 0,
  addcom = TRUE
)
}
\arguments{
\item{s}{A numeric vector with the sihouette coefficient of each point in a classification, as returned by CalculateSilhouette.}

\item{L}{A list of two numeric vectors, L$med and L$clasif, obtained normally as the object returned by ApplyPAM.}

\item{fallcounts}{A string with the name of the binary file containing the matrix of counts per cell. It can be either a full or a sparse matrix.}

\item{ffilcounts}{A string with the name of the binary file that will contain the selected cells. It will have the same character (full/sparse) and type of the complete file.}

\item{falldissim}{A string with the name of the binary file containing the dissimilarity matrix of the complete set of cells. It must be a symmetric matrix of floats.}

\item{ffildissim}{A string with the name of the binary file that will contain  the dissimilarity matrix for the remaining cells. It will be a symmetric matrix of floats.}

\item{thres}{Threshold to filter. All points whose silhouette is below this threshold will be filtered out. Default: 0.0 (remember that silhouette is in [-1..1])}

\item{addcom}{Boolean to indicate if a comment must be appended to the current comment of counts and dissimilarity matrices to indicate that they are the result of a filtering process. This comment is automatically generated and contains the value of threshold t. Succesive applications add comments at the end of those already present. Default: TRUE}
}
\value{
Lr["med","clasif"] A list of two numeric vectors.\cr
                     Lr$med is a modification of the correponding first element of the passed L parameter.\cr
                     Lr$clasif has as many components as remaining instances.\cr
                     Since points will have been removed, medoid numbering is modified. Therefore, Lr$med has the NEW index of each medoid in the filtered set.\cr
                     Lr$clasif contains the number of the medoid (i.e.: the cluster) to which each instance has been assigned, and therefore does not change.\cr
                     All indexes start at 1 (R convention). Please, see Details section\cr
}
\description{
Takes a silhouette, as returned by CalculateSilhouette, the list of medoids and class assignments, as returned by ApplyPam,
a threshold and the matrices of counts and dissimilarities and constructs the corresponding matrices clearing off the points (cells) whose silhoutte is
below the threshold, except if they are medoids.\cr
}
\details{
The renumbering of indices in the returned cluster may seem confusing at first but it was the way of fitting this with the rest
of the package. Anyway, notice that if the numeric vectors in the input parameter L were named vectors, the cells names are appropriately kept
in the result so cell identity is preserved. Moreover, if the counts and dissimilarity input matrices had row and/or column names, they
are preserved in the filtered matrices, too.
}
\examples{
# Synthetic problem: 10 random seeds with coordinates in [0..20]
# to which random values in [-0.1..0.1] are added
M<-matrix(0,100,500)
rownames(M)<-paste0("rn",c(1:100))
for (i in (1:10))
{
 p<-20*runif(500)
 Rf <- matrix(0.2*(runif(5000)-0.5),nrow=10)
 for (k in (1:10))
 {
  M[10*(i-1)+k,]=p+Rf[k,]
 }
}
tmpfile1=paste0(tempdir(),"/pamtest.bin")
JWriteBin(M,tmpfile1,dtype="float",dmtype="full")
tmpdisfile1=paste0(tempdir(),"/pamDl2.bin")
CalcAndWriteDissimilarityMatrix(tmpfile1,tmpdisfile1,distype="L2",restype="float",nthreads=0)
L <- ApplyPAM(tmpdisfile1,10,init_method="BUILD")
# Which are the medoids
L$med
sil <- CalculateSilhouette(L$clasif,tmpdisfile1)
tmpfiltfile1=paste0(tempdir(),"/pamtestfilt.bin")
tmpfiltdisfile1=paste0(tempdir(),"/pamDL2filt.bin")
Lf<-FilterBySilhouetteThreshold(sil,L,tmpfile1,tmpfiltfile1,tmpdisfile1,tmpfiltdisfile1,
                               thres=0.4,addcom=TRUE)
# The new medoids are the same points but renumbered, since the L$clasif array has less points
Lf$med
}
