% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatterPlotMatrix.R
\name{setKeptColumns}
\alias{setKeptColumns}
\title{Column visibility}
\usage{
setKeptColumns(id, keptColumns)
}
\arguments{
\item{id}{Output variable to read from (id which references the requested plot).}

\item{keptColumns}{Vector of boolean (one for each data column), \code{FALSE} if column has to be hidden.
A named list can also be provided to only indicate which columns must be assigned to a new visibility.}
}
\value{
No return value, called from shiny applications for side effects.
}
\description{
Tells which columns have to be visible.
}
\examples{
 if(interactive()) {
   library(shiny)
   library(scatterPlotMatrix)

   ui <- fluidPage(
     checkboxInput("hideColumnsCB", "Hide last columns", FALSE),
     p("The check box controls the visibility of the two last columns"),
     scatterPlotMatrixOutput("spMatrix")
   )

   server <- function(input, output, session) {
     output$spMatrix <- renderScatterPlotMatrix({
       scatterPlotMatrix(iris)
     })
     observeEvent(input$hideColumnsCB, {
       keptColumns <- vapply(
         1:ncol(iris),
         function(i) {
           return(ifelse(input$hideColumnsCB, ncol(iris) - i >= 2, TRUE))
         },
         logical(1)
       )
       scatterPlotMatrix::setKeptColumns("spMatrix", keptColumns)
     })
   }

   shinyApp(ui, server)
 }

}
