% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_zip.R
\name{zip_statistic_term}
\alias{zip_statistic_term}
\title{Calculate a term in the sum of the logarithm of the ZIP window statistic.}
\usage{
zip_statistic_term(q, p, dstar, ddagger, mu, y)
}
\arguments{
\item{q}{Scalar; the relative risk.}

\item{p}{Numeric vector of excess zero probabilities.}

\item{dstar}{Numeric vector of estimates of the excess zero indicators, under 
the alternative hypothesis of an outbreak. Of same length as \code{p}.}

\item{ddagger}{Numeric vector of estimates of the excess zero indicators, 
under the null hypothesis of no outbreak. Of same length as \code{p}.}

\item{mu}{Numeric vector of given/estimated Poisson expected value 
parameters. Of same length as \code{p}.}

\item{y}{Integer vector of observed counts. Of same length as \code{p}.}
}
\value{
A numeric vector of same length as input vector \code{p}.
}
\description{
This function calculates a term which appears in the sum of the logarithm of
the zero-inflated Poisson statistic for a given space-time window.
}
\keyword{internal}

