% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zones.R
\name{dist_to_knn}
\alias{dist_to_knn}
\title{Given a distance matrix, find the \eqn{k} nearest neighbors.}
\usage{
dist_to_knn(x, k = min(10, nrow(x)))
}
\arguments{
\item{x}{A (square) distance matrix. Elements should be non-negative and the 
diagonal zeros, but this is not checked.}

\item{k}{The number of nearest neighbors, counting the location itself.}
}
\value{
A matrix of integers, row \eqn{i} containing the \eqn{k} nearest 
   neighbors of location \eqn{i}, including itself.
}
\description{
Given a distance matrix, calculate the \eqn{k} nearest neighbors of each 
location, including the location itself. The matrix should contain only zeros 
on the diagonal, and all other elements should be positive.
}
\examples{
x <- matrix(c(0, 0,
              1, 0,
              2, 1,
              0, 4,
              1, 3),
            ncol = 2, byrow = TRUE)
d <- dist(x, diag = TRUE, upper = TRUE)
dist_to_knn(d, k = 3)
}

