% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R, R/export.sc_desc.R,
%   R/export.sc_nap.R, R/export.sc_overlap.R, R/export.sc_pem.R,
%   R/export.sc_pet.R, R/export.sc_pnd.R, R/export.sc_power.R,
%   R/export.sc_smd.R, R/export.sc_trend.R, R/export.scdf.R,
%   R/export.scdf_summary.R, R/print-export-plm.R
\name{export}
\alias{export}
\alias{export.sc_desc}
\alias{export.sc_nap}
\alias{export.sc_overlap}
\alias{export.sc_pem}
\alias{export.sc_pet}
\alias{export.sc_pnd}
\alias{export.sc_power}
\alias{export.sc_smd}
\alias{export.sc_trend}
\alias{export.scdf}
\alias{export.scdf_summary}
\alias{export.sc_plm}
\title{Export scan objects to html or latex}
\usage{
export(object, ...)

\method{export}{sc_desc}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  kable_styling_options = list(),
  kable_options = list(),
  flip = FALSE,
  round = 2,
  ...
)

\method{export}{sc_nap}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  kable_styling_options = list(),
  kable_options = list(),
  select = c("Case", "NAP", "NAP Rescaled", "w", "p", "d", "R²"),
  round = 2,
  ...
)

\method{export}{sc_overlap}(
  object,
  caption = NA,
  footnote = NULL,
  filename = NA,
  kable_styling_options = list(),
  kable_options = list(),
  round = 2,
  decimals = 2,
  flip = FALSE,
  ...
)

\method{export}{sc_pem}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  kable_styling_options = list(),
  kable_options = list(),
  round = 2,
  ...
)

\method{export}{sc_pet}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  kable_styling_options = list(),
  kable_options = list(),
  round = 1,
  ...
)

\method{export}{sc_pnd}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  kable_styling_options = list(),
  kable_options = list(),
  select = c("Case", "PND", "Total", "Exceeds"),
  round = 2,
  ...
)

\method{export}{sc_power}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  kable_styling_options = list(),
  kable_options = list(),
  round = 3,
  ...
)

\method{export}{sc_smd}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  select = c("Case", `Mean A` = "mA", `Mean B` = "mB", `SD A` = "sdA", `SD B` = "sdB",
    `SD Cohen` = "sd cohen", `SD Hedges` = "sd hedges", "Glass' delta", "Hedges' g",
    "Hedges' g correction", "Hedges' g durlak correction", "Cohen's d"),
  kable_styling_options = list(),
  kable_options = list(),
  round = 2,
  decimals = 2,
  flip = FALSE,
  ...
)

\method{export}{sc_trend}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  kable_styling_options = list(),
  kable_options = list(),
  round = 2,
  decimals = 2,
  ...
)

\method{export}{scdf}(
  object,
  summary = FALSE,
  caption = NA,
  footnote = NA,
  filename = NA,
  kable_styling_options = list(),
  kable_options = list(),
  cols,
  round = 2,
  ...
)

\method{export}{scdf_summary}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  kable_styling_options = list(),
  kable_options = list(),
  round = 2,
  ...
)

\method{export}{sc_plm}(
  object,
  caption = NA,
  footnote = NA,
  filename = NA,
  kable_styling_options = list(),
  kable_options = list(),
  nice = TRUE,
  ci = 0.95,
  q = FALSE,
  ...
)
}
\arguments{
\item{object}{An scdf or an object exported from a scan function.}

\item{...}{Further Arguments passed to internal functions.}

\item{caption}{Character string with table caption. If left NA (default) a
caption will be created based on the exported object.}

\item{footnote}{Character string with table footnote. If left NA (default) a
footnote will be created based on the exported object.}

\item{filename}{String containing the file name. If a filename is given the
output will be written to that file.}

\item{kable_styling_options}{list with arguments passed to the kable_styling
function.}

\item{kable_options}{list with arguments passed to the kable function.}

\item{flip}{If TRUE, some objects are exported with rows and columns flipped.}

\item{round}{Integer passed to the digits argument internally used to round
values.}

\item{select}{A character vector containing the names of the variables to be
included. If the vector is named, the variables will be renamed
accordingly.}

\item{decimals}{Decimal places that are reported.}

\item{summary}{If TRUE, exports the summary of an \code{scdf}.}

\item{cols}{Defines which columns are included when exporting an scdf. It is
either a vector of variable names or the string "main" will select the
central variables.}

\item{nice}{If set TRUE (default) output values are rounded and optimized for
publication tables.}

\item{ci}{Print confidence intervals. Either FALSE, TRUE or a number
between 0 and 1 (0.90 for a 90\% intervals).}

\item{q}{Logical. If set \code{TRUE}, Yule's Q is reported.}
}
\value{
Returns or displays a specially formatted html (or latex) file.
}
\description{
Export creates html files of tables or displays them directly in the viewer
pane of rstudio. When applied in rmarkdown/quarto, tables can also be created
for pdf/latex output.
}
